//
//  AddressViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AddressViewController.h"
#import "ModifyShippingAddressView.h"

@interface AddressViewController ()


/**
 *  城市选择器
 */
@property (nonatomic,strong)ModifyShippingAddressView *citySelecteview;
@end

@implementation AddressViewController


/**
 *  城市选择View
 *
 *  @return ModifyShippingAddressView
 */
- (ModifyShippingAddressView *)citySelecteview
{
    if (_citySelecteview == nil) {
        
        _citySelecteview = [[[NSBundle mainBundle] loadNibNamed:@"ModifyShippingAddressView"
                                                          owner:self options:nil]lastObject];
    }
    return _citySelecteview;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    
    [self uiConfigAction];
}


#pragma mark -布局
- (void)uiConfigAction
{
    self.recipientUserBackview.layer.masksToBounds = YES;
    self.recipientUserBackview.layer.cornerRadius = kCornerRadius;
    self.phoneNumberBackview.layer.masksToBounds = YES;
    self.phoneNumberBackview.layer.cornerRadius = kCornerRadius;
    self.detailsAddressBackview.layer.masksToBounds = YES;
    self.detailsAddressBackview.layer.cornerRadius = kCornerRadius;
    self.citySelected.layer.masksToBounds = YES;
    self.citySelected.layer.cornerRadius = kCornerRadius;
    
}

#pragma mark -取消弹出的圆角
- (void)viewWillAppear:(BOOL)animated
{
    self.view.superview.layer.cornerRadius = 0;
}



#pragma mark -城市选择器
- (void)SelectedCityButtonClick
{
    
    self.citySelecteview.frame = CGRectMake(0, self.view.frame.size.height, self.view.frame.size.width, 160);
    [self.view addSubview:self.citySelecteview];
    [self.citySelecteview.selectedCityButton addTarget:self action:@selector(CompleteButton) forControlEvents:UIControlEventTouchUpInside];
    [UIView animateWithDuration:0.2 animations:^{
        
        self.citySelecteview.frame = CGRectMake(0, self.view.frame.size.height-160, self.view.frame.size.width, 160);
    }completion:^(BOOL finished) {
        
        self.citySelected.enabled = NO;
    }];
}


#pragma mark -完成按钮点击
- (void)CompleteButton
{
    [UIView animateWithDuration:0.2 animations:^{
        
        self.citySelecteview.frame = CGRectMake(0, ScreenHeight, self.view.frame.size.width, 160);
    }completion:^(BOOL finished) {
        
        [self.citySelecteview removeFromSuperview];
        self.citySelecteview = nil;
        self.citySelected.enabled = YES;
    }];
}



#pragma mark -关闭地址输入框
- (IBAction)turnoffAddressView:(UIButton *)sender {
    
    [self dismissViewControllerAnimated:YES completion:nil];
}




/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
