//
//  RightViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RightViewController.h"
#import "AppDelegate.h"






@interface RightViewController ()<UITableViewDataSource,UITableViewDelegate>

@property (nonatomic,strong) UITableView *rightTableview;
@property (nonatomic,strong) NSMutableArray *dataArray;
@property (nonatomic,strong) NSArray *imageArray;

@property (nonatomic,assign) BOOL isOpen;

@end

@implementation RightViewController

/**
 *  初始化数据源
 *
 *  @return NSArray
 */
- (NSArray *)dataArray
{
    if (_dataArray == nil) {
        
        _dataArray = [NSMutableArray arrayWithObjects:@"体验中心",@"场景库",@"产品库",@"客户管理",@"关于", nil];
    }
    return _dataArray;
}



/**
 *  图片
 */
- (NSArray *)imageArray
{
    if (_imageArray == nil) {
        
        _imageArray = [NSArray arrayWithObjects:@"tiyan",@"changjing",@"chanping",@"kehu",@"guanyu", nil];
    }
    return _imageArray;
}



- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
}

#pragma mark -布局
- (void)uiConfigAction
{
    self.rightTableview = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, RightWidth, ScreenHeight) style:UITableViewStylePlain];
    self.rightTableview.delegate = self;
    self.rightTableview.dataSource = self;
    [self.view addSubview:self.rightTableview];
    self.rightTableview.tableFooterView = [UIView new];
    self.rightTableview.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.rightTableview registerClass:[UITableViewCell class] forCellReuseIdentifier:@"rightcell"];
    [self createHeaderview];
}

#pragma mark -头部视图
- (void)createHeaderview
{
    UIView *headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, RightWidth, 200)];
    UIImageView *imageView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 80, 80)];
    imageView.center = CGPointMake(RightWidth/2, 100);
    imageView.image = TCImage(@"weibo");
    [headerView addSubview:imageView];
    self.rightTableview.tableHeaderView = headerView;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"rightcell" forIndexPath:indexPath];
    cell.textLabel.text = [self.dataArray objectAtIndex_opple:indexPath.row];
    if (self.isOpen && ([cell.textLabel.text isEqualToString:@"所有客户"] || [cell.textLabel.text isEqualToString:@"客户订单"])) {
        
        cell.backgroundColor = kMainBlueColor;
    }
    else
    {
        cell.imageView.image = [UIImage imageNamed:[self.imageArray objectAtIndex_opple:indexPath.row]];
    }
    
    
    return  cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    if ([cell.textLabel.text isEqualToString:@"客户管理"] ) {
        
        if (!self.isOpen) {
            
            self.isOpen = YES;
            [self.dataArray insertObject:@"所有客户" atIndex:self.dataArray.count-1];
            [self.dataArray insertObject:@"客户订单" atIndex:self.dataArray.count-1];
            [self.rightTableview insertRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:4 inSection:0],[NSIndexPath indexPathForRow:5 inSection:0]] withRowAnimation:UITableViewRowAnimationMiddle];
        }
        else
        {
            [self recoveryCell];
        }
    }else
    {
        if (![[self.dataArray objectAtIndex_opple:indexPath.row]isEqualToString:@"体验中心"]) {
            //收起右侧控制器
            [SHARED_APPDELEGATE.mmdrawer toggleDrawerSide:MMDrawerSideRight animated:YES completion:^(BOOL finished) {
                
                [self recoveryCell];
            }];

        }
        
        if ([self.delegate respondsToSelector:@selector(SelectedControllerWithIndex:)]) {
            
            [self.delegate SelectedControllerWithIndex:[self.dataArray objectAtIndex_opple:indexPath.row]];
        }
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 60;
}


#pragma mark -复原cell
- (void)recoveryCell
{
    if ([self.dataArray containsObject:@"所有客户"] && [self.dataArray containsObject:@"客户订单"]) {
        
        self.isOpen = NO;
        [self.dataArray removeObject:@"所有客户"];
        [self.dataArray removeObject:@"客户订单"];
        [self.rightTableview deleteRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:4 inSection:0],[NSIndexPath indexPathForRow:5 inSection:0]] withRowAnimation:UITableViewRowAnimationMiddle];
    }
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
