//
//  FollowHeartViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "FollowHeartViewController.h"
#import <QuartzCore/QuartzCore.h>
#import "ImageCropperView.h"

@interface FollowHeartViewController ()

@end

@implementation FollowHeartViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self configSubView];
    
}
-(void)configSubView
{
    self.backGroundImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"backView.png"]];
    self.backGroundImageView.frame=CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    [self.view addSubview:self.backGroundImageView];
    self.leftSubView=[[LeftSubView alloc]initWithFrame:CGRectMake(0, 0, 200, ScreenHeight-200)];
    self.leftSubView.delegate=self;
    [self.view addSubview:self.leftSubView];
    self.rightSubView=[[RightSubView alloc]initWithFrame:CGRectMake(ScreenWidth-200, 0, 200, ScreenHeight-200)];
    self.rightSubView.delegate=self;
    [self.view addSubview:self.rightSubView];
    
    self.footSubView=[[FootSubView alloc]initWithFrame:CGRectMake(0, ScreenHeight-200, ScreenWidth, 200)];
    self.footSubView.delegate=self;
    [self.view addSubview:self.footSubView];
    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView:)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [[UIApplication sharedApplication].keyWindow addGestureRecognizer:tap];



}
#pragma  subView  delegate
- (void)buttonClick:(NSInteger)btnTag withButton:(UIButton *)button
{
    switch (btnTag) {
        case 100:  //返回
        {
            [self.view removeFromSuperview];
        }
            break;
        case 101:  //购物车
        {
            
        }
            break;
        case 102:  //分享
        {
            
        }
            break;
        case 103:  //自定义场景
        {
            
        }
            break;
        case 104:  //全屏
        {

            [self setViewAnimations:button];
            
        }
            break;
        case 105: //帮助
        {
            
        }
            break;
        case 200: //场景
        {
            [self addSceneLibraryView];
        }
            break;
        case 300: //产品
        {
            [self addProductLibraryView];
        }
            break;
            
        default:
            break;
    }

}
//场景赋图回调
- (void)resetSuperBackGroundImage:(UIImage*)image
{
    self.backGroundImageView.image=image;
}
//产品附图回调
- (void)addProductImage:(UIImage*)image
{
    ImageCropperView *cropper=[[ImageCropperView alloc]initWithFrame:CGRectMake(400, 300, 300, 300)];
//    cropper.center=self.view.center;
//    cropper.bounds=CGRectMake(0, 0, 200, 200);
    cropper.layer.borderWidth = 1.0;
    cropper.layer.borderColor = [UIColor blueColor].CGColor;
//    [cropper setup];
    cropper.image = image;
    [self.view addSubview:cropper];
}
-(void)setViewAnimations:(UIButton *)sender
{
    UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame=sender.frame;
    [btn setTitle:@"缩小" forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(resetViewDidSelected:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:btn];

    [UIView beginAnimations:nil context:nil];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDuration:1.0f];
    self.leftSubView.frame=CGRectMake(-200, 0, 200, ScreenHeight-200);
    self.rightSubView.frame=CGRectMake(ScreenWidth, 0, 200, ScreenHeight-200);
    self.footSubView.frame=CGRectMake(0, ScreenHeight, ScreenWidth, 200);
    btn.frame=CGRectMake(sender.frame.origin.x, 20, sender.frame.size.width, sender.frame.size.height);
    [UIView commitAnimations];
}
-(void)resetViewDidSelected:(UIButton *)sender
{
    [UIView beginAnimations:nil context:nil];
    [UIView setAnimationDelegate:self];
    [UIView setAnimationDuration:1.0f];
    self.leftSubView.frame=CGRectMake(0, 0, 200, ScreenHeight-200);
    self.rightSubView.frame=CGRectMake(ScreenWidth-200, 0, 200, ScreenHeight-200);
    self.footSubView.frame=CGRectMake(0, ScreenHeight-200, ScreenWidth, 200);
    sender.hidden=YES;
    [UIView commitAnimations];

}
//添加场景
-(void)addSceneLibraryView
{
    self.seceneLibraryView=[[SeceneLibraryView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-200, ScreenHeight-200)];
    [self.view addSubview:self.seceneLibraryView];
}
//添加产品
-(void)addProductLibraryView
{
    self.productLibraryView=[[ProductLibraryView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-200, ScreenHeight-200)];
    [self.view addSubview:self.productLibraryView];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(void)DismissScreenView:(UITapGestureRecognizer*)sender{
    CGPoint point = [sender locationInView:self.view];
    if (point.x<100 || point.x >ScreenWidth-100||point.y<50||point.y>ScreenHeight-150) {

            if (self.seceneLibraryView) {
                [self.seceneLibraryView removeFromSuperview];
            }
            if (self.productLibraryView) {
                [self.productLibraryView removeFromSuperview];
            }
            
        
    }
    
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
