//
//  BaseViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"

@interface BaseViewController ()

@property (nonatomic,strong) MBProgressHUD*TCHud;

@end

@implementation BaseViewController


/**
 *  创建MBProgressHUD对象
 *
 *  @return MBProgressHUD
 */
- (MBProgressHUD *)TCHud
{
    if (_TCHud == nil) {
        
        _TCHud = [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    }
    return _TCHud;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark -渐隐提示框回调
- (void)SHOWPrompttext:(NSString *)Text ComcpleteBlock:(void(^)())completed
{
    MBProgressHUD *hud = [[MBProgressHUD alloc]initWithView:self.view];
    hud.labelText = Text;
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:2.0f];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (completed) {
            completed();
        }
    });
}

#pragma mark -显示MBProgressHUD等待视图
- (void)CreateMBProgressHUDLoding:(NSString *)ShowText
{
    if(ShowText==nil)
    {
        ShowText = @"加载中";
    }
    self.TCHud.labelText = ShowText;
    self.TCHud.animationType = MBProgressHUDAnimationZoom;
    self.TCHud.mode = MBProgressHUDModeIndeterminate;
    self.TCHud.activityIndicatorColor = [UIColor redColor];
    self.TCHud.removeFromSuperViewOnHide = YES;
}

#pragma mark -移除MBProgressHUD等待视图
- (void)RemoveMBProgressHUDLoding:(NSString *)Endstring;
{
    if (Endstring != nil) {
        self.TCHud.labelText = Endstring;
    }
    [self.TCHud hide:YES afterDelay:1];
    self.TCHud = nil;
}

#pragma mark -结束MJRfresh刷新
- (void)endRefreshingForTableView:(UIScrollView *)TableView
{
    if (TableView.mj_header.isRefreshing) {
        
        [TableView.mj_header endRefreshing];
    }
    else if (TableView.mj_footer.isRefreshing)
    {
        [TableView.mj_footer endRefreshing];
    }
}


@end
