
//
//  CustomTabbarController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomTabbarController.h"
#import "Toolview.h"
#import "AppDelegate.h"

@interface CustomTabbarController ()<TabbarButtonClickdelegate>

@property (nonatomic,strong) NSArray *identifierArray;
@property (nonatomic,strong) NSArray *controllerArray;

@end

@implementation CustomTabbarController

/**
 *  UIStoryboard Identifier数组
 *
 *  @return NSArary
 */
- (NSArray *)identifierArray
{
    if (_identifierArray == nil) {
        
        _identifierArray = [NSArray arrayWithObjects:@"shopping",@"Client", nil];
    }
    return _identifierArray
    ;
}


- (NSArray *)controllerArray
{
    if (_controllerArray == nil) {
        
        _controllerArray = [NSArray arrayWithObjects:@"ShoppingViewController",@"ClientViewController", nil];
    }
    return _controllerArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    

    [self uiConfigAction];
    [self addViewcontroller];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.tabBar.frame = CGRectMake(Zero, Zero, ScreenWidth, NavigationHeight);
    Toolview *toolview = [[Toolview alloc]initWithFrame:CGRectMake(Zero, Zero, ScreenWidth, NavigationHeight)];
    toolview.delegate = self;
    [self.tabBar addSubview:toolview];
}


#pragma mark -添加controller
- (void)addViewcontroller
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    ShoppingViewController *shoppingVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray firstObject]];
    ClientViewController *clientVC = [storyboard instantiateViewControllerWithIdentifier:[self.identifierArray objectAtIndex_opple:1]];
    NSArray *vcArray = [NSArray arrayWithObjects:clientVC,shoppingVC, nil];
    self.viewControllers = vcArray;
}


#pragma amrk -TabbarButtonClickdelegate代理
- (void)ButtonClickAction:(NSInteger)Buttontag
{
    
    switch (Buttontag) {
            
            //
        case 100:
            
            [SHARED_APPDELEGATE.mmdrawer toggleDrawerSide:MMDrawerSideRight animated:YES completion:nil];
            
            break;
        case 101:
            
            break;
        case 102:
            
            self.selectedIndex = 0;
            
            break;
        case 103:
            
             self.selectedIndex = 1;
            
            break;
            
        default:
            break;
    }
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
