//
//  CustomWKWebViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/17.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomWKWebViewController.h"
#import <WebKit/WebKit.h>

@interface CustomWKWebViewController ()<WKNavigationDelegate,WKScriptMessageHandler,UIScrollViewDelegate,WKUIDelegate>

@property (nonatomic,strong) WKWebView *webView;
@property (nonatomic,strong) WKWebViewConfiguration *config;
@property (nonatomic,strong) UIButton *dismissButton;

@end

@implementation CustomWKWebViewController

#pragma mark - lazy
- (WKWebViewConfiguration *)config
{
    if (!_config) {
        _config = [[WKWebViewConfiguration alloc]init];
        // 设置偏好设置
        _config.preferences = [[WKPreferences alloc] init];
        // 默认为0
        _config.preferences.minimumFontSize = 10;
        // 默认认为YES
        _config.preferences.javaScriptEnabled = YES;
        // 在iOS上默认为NO，表示不能自动通过窗口打开
        _config.preferences.javaScriptCanOpenWindowsAutomatically = NO;
        
        
        // 通过JS与webview内容交互
        _config.userContentController = [[WKUserContentController alloc] init];
        [_config.userContentController addScriptMessageHandler:self name:@"AppModel"];
    }
    return _config;
}

- (WKWebView *)webView
{
    if (!_webView) {
        _webView = [[WKWebView alloc] initWithFrame:self.view.bounds configuration:self.config];
        _webView.navigationDelegate = self;
        _webView.UIDelegate = self;
        _webView.scrollView.delegate = self;
        [self.view insertSubview:_webView atIndex:0];
    }
    return _webView;
}

#pragma mark - 停止播放
-(void)viewDidDisappear:(BOOL)animated{
    [super viewDidDisappear:animated];
    [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:@"about:blank"]]];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self determineTheURLFileType];
    [self addDismissButton];
}

#pragma mark - 判断加载文件类型
- (void)determineTheURLFileType
{
    [self loadURLfileAction];
}

#pragma mark - 加载URL
- (void)loadURLfileAction
{
    NSSet *websiteDataTypes = [WKWebsiteDataStore allWebsiteDataTypes];
    NSDate *dateFrom = [NSDate dateWithTimeIntervalSince1970:0];
    [[WKWebsiteDataStore defaultDataStore] removeDataOfTypes:websiteDataTypes modifiedSince:dateFrom completionHandler:^{
        NSLog(@"清理缓存成功");
    }];
}

#pragma mark - 数据
- (void)setUrlString:(NSString *)urlString
{
    _urlString = urlString;
    if (self.type == Image) {
       [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL fileURLWithPath:urlString]]];
    }else {
        [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:urlString]]];
    }
}

#pragma mark - 添加删除按钮
- (void)addDismissButton
{
    self.dismissButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.view addSubview:self.dismissButton];
    [self.dismissButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(40);
        make.top.mas_equalTo(40);
        make.size.mas_equalTo(CGSizeMake(50, 50));
    }];
    [self.dismissButton setBackgroundImage:TCImage(@"1") forState:UIControlStateNormal];
    [self.dismissButton addTarget:self action:@selector(dismissButtonClick) forControlEvents:UIControlEventTouchUpInside];
}

#pragma mark - WKScriptMessageHandler
- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message
{
    if ([message.name isEqualToString:@"AppModel"]) {
        // 打印所传过来的参数，只支持NSNumber, NSString, NSDate, NSArray,
        // NSDictionary, and NSNull类型
       id json = [NSJSONSerialization JSONObjectWithData:[message.body[@"body"] dataUsingEncoding:NSUTF8StringEncoding] options:NSJSONReadingMutableContainers error:nil];
        if (json) {
            if ([json isKindOfClass:[NSDictionary class]]) {
                NSDictionary *resultDict = (NSDictionary *)json;
                if ([[resultDict allKeys] containsObject:@"click"]) {
                    self.dismissButton.enabled = NO;
                }else {
                    self.dismissButton.enabled = YES;
                    if (self.luckyDrawFinishBlock) {
                        self.luckyDrawFinishBlock(resultDict);
                    }
                }
            }
        }
    }
}

-(WKWebView *)webView:(WKWebView *)webView createWebViewWithConfiguration:(WKWebViewConfiguration *)configuration forNavigationAction:(WKNavigationAction *)navigationAction windowFeatures:(WKWindowFeatures *)windowFeatures
{
    if (!navigationAction.targetFrame.isMainFrame) {
        [webView loadRequest:navigationAction.request];
    }
    return nil;
}

#pragma mark -dismiss
- (void)dismissButtonClick
{
    WS(weakSelf);
    [self dismissViewControllerAnimated:YES completion:^{
        if (weakSelf.dismissLuckyDrawController) {
            weakSelf.dismissLuckyDrawController();
        }
    }];
}

- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(null_unspecified WKNavigation *)navigation
{
    [XBLoadingView showHUDViewWithDefault];
}

- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation
{
    [XBLoadingView hideHUDViewWithDefault];
}

- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
    [XBLoadingView hideHUDViewWithDefault];
}

#pragma mark - <UIScrollViewDelegate>
- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
    CGFloat height = scrollView.frame.size.height;
    CGFloat contentYoffset = scrollView.contentOffset.y;
    CGFloat distanceFromBottom = scrollView.contentSize.height - contentYoffset;
    WS(weakSelf);
    if (distanceFromBottom <= height && self.type == Study) {
        ShowDefaultAlertView(self, nil, @"学习完成，是否开始考核？", UIAlertControllerStyleAlert, ^{
            if (weakSelf.scrollViewEndBottomBlock) {
                weakSelf.scrollViewEndBottomBlock(weakSelf.indexPath);
            }
        }, nil);
    }
}





@end
