//
//  PDFViewController.h
//  Lighting
//
//  Created by 曹云霄 on 16/5/17.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"


/**
 调用类型

 - Announcement: 公告
 - Study:        学习
 - Image:        本地图片
 */
typedef NS_ENUM(NSInteger,CALL_TYPE) {
    Announcement = 0,
    Study,
    Image
};

@interface CustomWKWebViewController : BaseViewController

/**
 调用类型
 */
@property (nonatomic,assign) CALL_TYPE type;


/**
 *  PDF文件URL
 */
@property (nonatomic,copy) NSString *urlString;

/**
 *  抽奖完成
 */
@property (nonatomic,copy) void(^luckyDrawFinishBlock)(NSDictionary *luckyDrawResultDict);

/**
 *  退出抽奖界面
 */
@property (nonatomic,copy) void(^dismissLuckyDrawController)();

/**
 滑动结束到底部
 */
@property (nonatomic,copy) void(^scrollViewEndBottomBlock)(NSIndexPath *indexPath);

/**
 学习项下标
 */
@property (nonatomic,strong) NSIndexPath *indexPath;


@end
