//
//  CustomButton.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomButton.h"
#import "instructionsLabe.h"
#define WIDTH self.frame.size.width


@implementation CustomButton



- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        self.titleLabel.font = [UIFont systemFontOfSize:11];
        self.titleLabel.textAlignment = NSTextAlignmentCenter;
        self.adjustsImageWhenHighlighted = NO;
    }
    return self;
}


- (void)setInstructionsNumber:(NSInteger)instructionsNumber
{
    _instructionsNumber = instructionsNumber;
    for (UIView *subview in self.subviews) {
        
        if ([subview isKindOfClass:[instructionsLabe class]]) {
            
            [subview removeFromSuperview];
            break;
        }
    }
    if (_instructionsNumber > 0) {
        instructionsLabe *labe = [[instructionsLabe alloc]initWithFrame:CGRectMake(WIDTH-25, 0, 13, 13)];
        labe.instructionsNumber = _instructionsNumber;
        [self addSubview:labe];
    }
}



- (CGRect)imageRectForContentRect:(CGRect)contentRect
{
    return CGRectMake((WIDTH-25)/2, 0, 25, 25);
}

- (CGRect)titleRectForContentRect:(CGRect)contentRect
{
    return CGRectMake(0, 30, WIDTH, 20);
}









@end
