
//
//  UIView+cornerRadius.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/26.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "UIView+cornerRadius.h"

@implementation UIView (cornerRadius)

- (void)setCornerRadius:(CGFloat)cornerRadius
{
    self.layer.masksToBounds = YES;
    self.layer.cornerRadius = cornerRadius;
}

- (CGFloat)cornerRadius
{
    return self.layer.cornerRadius;
}

- (CGFloat) x {
    return self.frame.origin.x;
}

- (void) setX:(CGFloat)x {
    CGRect nframe = self.frame;
    
    nframe.origin.x = x;
    
    self.frame = nframe;
}

- (CGFloat) y {
    return self.frame.origin.y;
}

- (void) setY:(CGFloat)y {
    CGRect nframe = self.frame;
    
    nframe.origin.y = y;
    
    self.frame = nframe;
}

// Retrieve and set height, width
- (CGFloat) width {
    return self.frame.size.width;
}

- (void) setWidth:(CGFloat)width {
    CGRect nframe = self.frame;
    
    nframe.size.width = width;
    
    self.frame = nframe;
}

- (CGFloat) height {
    return self.frame.size.height;
}

- (void) setHeight:(CGFloat)height {
    CGRect nframe = self.frame;
    
    nframe.size.height = height;
    
    self.frame = nframe;
}

// Retrieve and set the origin, size
- (CGPoint) origin {
    return self.frame.origin;
}

- (void) setOrigin:(CGPoint)aPoint {
    CGRect nframe = self.frame;
    
    nframe.origin = aPoint;
    
    self.frame = nframe;
}

- (CGSize) size {
    return self.frame.size;
}

- (void) setSize:(CGSize)aSize {
    CGRect nframe = self.frame;
    
    nframe.size = aSize;
    
    self.frame = nframe;
}

- (CGFloat) left {
    return self.x;
}

- (void) setLeft:(CGFloat)left {
    self.x = left;
}

- (CGFloat) right {
    return CGRectGetMaxX(self.frame);
}

- (void) setRight:(CGFloat)right {
    self.x = right - self.width;
}

- (CGFloat) top {
    return self.y;
}

- (void) setTop:(CGFloat)top {
    self.y = top;
}

- (CGFloat) bottom {
    return CGRectGetMaxY(self.frame);
}

- (void) setBottom:(CGFloat)bottom {
    self.y = bottom - self.height;
}



@end
