//
//  AppDelegate.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AppDelegate.h"
#import "LoginViewController.h"
#import "DeviceDirectionManager.h"
#import "UMMobClick/MobClick.h"
#import <Bugly/Bugly.h>

@interface AppDelegate ()<JPUSHRegisterDelegate>

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // Override point for customization after application launch.

    [Bugly startWithAppId:@"900033734"];
    [self setUMShare];
    [self detectionNetwork];
    [self SetIQKeyboardManager];
    [self RootViewcontroller];
    [self setUpJPush:launchOptions];
    return YES;
}

#pragma mark -设置JPush
- (void)setUpJPush:(NSDictionary *)launchOptions
{
    //Required
    //notice: 3.0.0及以后版本注册可以这样写，也可以继续用之前的注册方式
    JPUSHRegisterEntity * entity = [[JPUSHRegisterEntity alloc] init];
    entity.types = JPAuthorizationOptionAlert|JPAuthorizationOptionBadge|JPAuthorizationOptionSound;
    [JPUSHService registerForRemoteNotificationConfig:entity delegate:self];
    
    // Required
    // init Push
    // notice: 2.1.5版本的SDK新增的注册方法，改成可上报IDFA，如果没有使用IDFA直接传nil
    // 如需继续使用pushConfig.plist文件声明appKey等配置内容，请依旧使用[JPUSHService setupWithOption:launchOptions]方式初始化。
    [JPUSHService setupWithOption:launchOptions appKey:@"a0f87c1c349d496ff85c3974"
                          channel:@"蒲公英"
                 apsForProduction:YES
            advertisingIdentifier:nil];
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(nullable UIWindow *)window
{
    //判断是否是横屏
    if ( [[DeviceDirectionManager instance] isHorizontal]) {
        return UIInterfaceOrientationMaskAll ;
    } else{
       return UIInterfaceOrientationMaskLandscape;
    }
}

//分享回调
- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation
{
    BOOL result = [UMSocialSnsService handleOpenURL:url];
    if (result == FALSE) {
        //调用其他SDK，例如支付宝SDK等
    }
    return result;
}
#pragma mark -设置根视图
- (void)RootViewcontroller
{
    LoginViewController *login = [[BaseViewController getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"Login"];
    self.window.rootViewController = login;
}


#pragma mark -接收到内存警告
- (void)applicationDidReceiveMemoryWarning:(UIApplication *)application
{
    [[SDImageCache sharedImageCache] clearDisk];
    [[SDImageCache sharedImageCache] setValue:nil forKey:@"memCache"];
}

#pragma mark - 键盘
- (void)SetIQKeyboardManager
{
    IQKeyboardManager *manager = [IQKeyboardManager sharedManager];
    [[IQKeyboardManager sharedManager]setKeyboardDistanceFromTextField:0];
    manager.enable = YES;
    manager.shouldResignOnTouchOutside = YES;
    manager.enableAutoToolbar = NO;
}


#pragma mark -检测网络的可连接性
- (void)detectionNetwork
{
    self.Networkstatus = true;
    [[AFNetworkReachabilityManager sharedManager] startMonitoring];
    [[AFNetworkReachabilityManager sharedManager] setReachabilityStatusChangeBlock:^(AFNetworkReachabilityStatus status) {
        
        switch (status) {
                
            case AFNetworkReachabilityStatusUnknown:
            case AFNetworkReachabilityStatusNotReachable:{
                
                NSLog(@"无网络");
                self.Networkstatus = false;
                break;
            }
            case AFNetworkReachabilityStatusReachableViaWiFi:{
                
                NSLog(@"WiFi网络");
                self.Networkstatus = true;
                break;
                
            }
            case AFNetworkReachabilityStatusReachableViaWWAN:{
                
                NSLog(@"流量网络");
                self.Networkstatus = true;
                break;
            }
            default:
                break;
        }
    }];
}

#pragma mark - 友盟
-(void)setUMShare
{
    [MobClick setLogEnabled:YES];
    // 友盟分享初始化
    [UMSocialData setAppKey:@"574bc8fee0f55a4edb001078"];
    // 设置微信AppId、appSecret，分享url
    [UMSocialWechatHandler setWXAppId:@"wxab385878d9441f23" appSecret:@"58b85af13973bdf597fa807208ac0dff " url:@"http://www.umeng.com/social"];
    // 设置微博的AppKey、appSecret，分享url
    [UMSocialSinaSSOHandler openNewSinaSSOWithAppKey:@"1111393286" secret:@"5d011c05122b5539ec9592372f944d3c" RedirectURL:@"http://sns.whalecloud.com/sina2/callback"];
    UMConfigInstance.appKey = @"574bc8fee0f55a4edb001078";
    UMConfigInstance.channelId = @"蒲公英";
    [MobClick startWithConfigure:UMConfigInstance];
}


#pragma mark -更新通知
- (void)updateVersion
{
    [Notification postNotificationName:UPLOADVERSION object:nil];
}

#pragma mark- JPUSHRegisterDelegate
#pragma mark -接收到通知回调
- (void)jpushNotificationCenter:(UNUserNotificationCenter *)center willPresentNotification:(UNNotification *)notification withCompletionHandler:(void (^)(NSInteger))completionHandler {
    // Required
    NSDictionary * userInfo = notification.request.content.userInfo;
    if([notification.request.trigger isKindOfClass:[UNPushNotificationTrigger class]]) {
        [JPUSHService handleRemoteNotification:userInfo];
    }
    completionHandler(UNNotificationPresentationOptionAlert);
}

#pragma mark -点击通知回调
- (void)jpushNotificationCenter:(UNUserNotificationCenter *)center didReceiveNotificationResponse:(UNNotificationResponse *)response withCompletionHandler:(void (^)())completionHandler {
    NSDictionary * userInfo = response.notification.request.content.userInfo;
    if([response.notification.request.trigger isKindOfClass:[UNPushNotificationTrigger class]]) {
        [JPUSHService handleRemoteNotification:userInfo];
    }
    [UserDefault setObject:userInfo forKey:NSNOTIFICATION_MESSAGE];
    [Notification postNotificationName:NSNOTIFICATION_MESSAGE object:userInfo];
    completionHandler();
}

- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo fetchCompletionHandler:(void (^)(UIBackgroundFetchResult))completionHandler {
    
    [JPUSHService handleRemoteNotification:userInfo];
    completionHandler(UIBackgroundFetchResultNewData);
}

#pragma mark -注册 DeviceToken
- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {
    
    [JPUSHService registerDeviceToken:deviceToken];
    [Notification addObserver:self selector:@selector(networkDidReceiveMessage:) name:kJPFNetworkDidLoginNotification object:nil];
}

#pragma mark -注册 DeviceToken失败
- (void)application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError *)error {
    //Optional
    NSLog(@"did Fail To Register For Remote Notifications With Error: %@", error);
    [XBLoadingView showHUDViewWithText:@"注册JPush失败"];
}

#pragma mark -登陆成功回调
- (void)networkDidReceiveMessage:(NSNotification *)notification {
    [Notification removeObserver:self name:kJPFNetworkDidLoginNotification object:nil];
    [self setUpJPushAlias];
}

#pragma mark -设置极光推送别名
- (void)setUpJPushAlias
{
    //极光推送别名
    [JPUSHService setTags:nil alias:[Shoppersmanager manager].shoppers.employee.fid fetchCompletionHandle:^(int iResCode, NSSet *iTags, NSString *iAlias) {
        NSLog(@"rescode: %d, \ntags: %@, \nalias: %@\n", iResCode, iTags , iAlias);
    }];
}


- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
    [self updateVersion];
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    // Saves changes in the application's managed object context before the application terminates.
}



@end
