//
//  ReadPacketStateViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/17.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "ReadPacketStateViewController.h"
#import "ReadPacketViewController.h"

@interface ReadPacketStateViewController ()

@property (nonatomic,strong) UIViewController *currentVC;
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *instructionViewConstraint;

@end

@implementation ReadPacketStateViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewController];
}

#pragma mark - 添加卡劵详情vc
- (void)addChildViewController
{
    /// 未审核
    ReadPacketViewController *unauditedVc = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"ReadPacketViewController"];
    [self addChildViewController:unauditedVc];
    unauditedVc.readPacketState = STUDYTASKSTATE_INITIAL;
    [self.controllerBackgroundView addSubview:unauditedVc.view];
    /// 已审核
    ReadPacketViewController *auditedVc = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"ReadPacketViewController"];
    auditedVc.readPacketState = STUDYTASKSTATE_USED;
    [self addChildViewController:auditedVc];
    self.currentVC = unauditedVc;
}

#pragma mark - 布局
- (void)viewDidLayoutSubviews
{
    ReadPacketViewController *unauditedVc = self.childViewControllers[0];
    unauditedVc.view.frame = CGRectMake(0, 0, self.controllerBackgroundView.mj_w, self.controllerBackgroundView.mj_h);
    
    ReadPacketViewController *auditedVc = self.childViewControllers[1];
    auditedVc.view.frame = CGRectMake(0, 0, self.controllerBackgroundView.mj_w, self.controllerBackgroundView.mj_h);
}


#pragma mark - 切换已使用卡劵、未使用卡劵
- (void)switchPaymentsVCAndWithdrawalVC:(UIViewController *)newViewController
{
    [self transitionFromViewController:self.currentVC toViewController:newViewController duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.controllerBackgroundView addSubview:newViewController.view];
            self.currentVC = newViewController;
        }
    }];
}

#pragma mark - 设置指示线的位置
- (void)setupInstructionsViewOrigin:(UIButton *)sender
{
    self.instructionViewConstraint.constant = sender.x+16;
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        [self.view layoutIfNeeded];
    } completion:nil];
}


#pragma mark - 切换ContentController
#pragma mark -红包状态  tag 100表示未审核，101表示已审核
- (IBAction)readPacketStateClickAction:(UIButton *)sender {
    
    for (id object in self.view.subviews) {
        if ([object isKindOfClass:[UIButton class]]) {
            UIButton *button = (UIButton *)object;
            button.selected = NO;
        }
    }
    sender.selected = YES;
    [self setupInstructionsViewOrigin:sender];
    [self switchPaymentsVCAndWithdrawalVC:self.childViewControllers[sender.tag-100]];
}


@end
