//
//  PrizeMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/22.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PrizeMainViewController.h"
#import "PrizeListCollectionViewCell.h"
#import "PrizeListModel.h"
#import "ApplyPrizeViewController.h"
#import "IntegralDetailsViewController.h"
#import "PrizeExchangeDetailsViewController.h"

@interface PrizeMainViewController ()<UICollectionViewDelegate,UICollectionViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

/**
 查询奖品列表
 */
@property (nonatomic,strong) PrizeCondition *queryPrizeModel;

/**
 奖品数据源
 */
@property (nonatomic,strong) NSMutableArray *prizeDatasArray;

/**
 总页数
 */
@property (nonatomic,assign) NSInteger totalPage;

/**
 是否有兑换资格
 */
@property (nonatomic,assign) NSInteger isQualified;

@end

@implementation PrizeMainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpCollectionView];
    [self setUpRefreshAction];
}

#pragma mark - UICollectionView
- (void)setUpCollectionView
{
    self.prizeCollectionViewFlowLayout.itemSize = CGSizeMake((ScreenWidth-100)/4, (ScreenWidth-100)/4);
    self.prizeCollectionViewFlowLayout.minimumLineSpacing = 20;
    self.prizeCollectionViewFlowLayout.minimumInteritemSpacing = 10;
    self.prizeCollectionViewFlowLayout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
}

#pragma mark - 设置刷新
- (void)setUpRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        [weakSelf.prizeListCollectionView.mj_footer resetNoMoreData];
        weakSelf.queryPrizeModel.page.page = ONE;
        [weakSelf getPrizeListDatasAction:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    [headerRefresh beginRefreshing];
    self.prizeListCollectionView.mj_header = headerRefresh;
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (++ weakSelf.queryPrizeModel.page.page >= weakSelf.totalPage) {
            [weakSelf.prizeListCollectionView.mj_footer endRefreshingWithNoMoreData];
        }else{
            [weakSelf getPrizeListDatasAction:NO];
        }
        
    }];
    footer.automaticallyHidden = YES;
    self.prizeListCollectionView.mj_footer = footer;
}

#pragma mark - 获取奖品列表、可申请礼品列表
- (void)getPrizeListDatasAction:(BOOL)isRemove
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    dispatch_group_t group = dispatch_group_create();
    dispatch_group_enter(group);
    //任务一 请求奖品列表
    [HTTP networkRequestWithURL:SERVERREQUESTURL(PRIZELIST) withRequestType:ZERO withParameter:self.queryPrizeModel withReturnValueBlock:^(id returnValue) {
        dispatch_group_leave(group);
        [weakSelf endRefreshingForTableView:weakSelf.prizeListCollectionView];
        weakSelf.prizeListCollectionView.emptyDataSetSource = weakSelf;
        weakSelf.prizeListCollectionView.emptyDataSetDelegate = weakSelf;
        if (RESULT(returnValue)) {
            if (isRemove) {
                [weakSelf.prizeDatasArray removeAllObjects];
            }
            PrizeResponse *prizeResult = [[PrizeResponse alloc]initWithDictionary:RESPONSE(returnValue) error:nil];
            weakSelf.totalPage = prizeResult.totalpages;
            for (TOPrizeEntity *prize in prizeResult.prizes) {
                PrizeListModel *model = [[PrizeListModel alloc]initWithSuper:prize];
                [weakSelf.prizeDatasArray addObject:model];
            }
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    } withFailureBlock:^(NSError *error) {
        dispatch_group_leave(group);
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
    //任务二  查询是否有兑换资格
    dispatch_group_enter(group);
    [HTTP networkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(EXCHANGEQUALIFICATION),[Shoppersmanager manager].shoppers.employee.fid] withRequestType:ONE withParameter:nil withReturnValueBlock:^(id returnValue) {
        
        dispatch_group_leave(group);
        if (RESULT(returnValue)) {
            weakSelf.isQualified = [RESPONSE(returnValue) integerValue];
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    }withFailureBlock:^(NSError *error) {
        dispatch_group_leave(group);
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
    // 所有请求完成后
    dispatch_group_notify(group, dispatch_get_main_queue(), ^{

        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.prizeListCollectionView];
        [weakSelf.prizeListCollectionView reloadData];
    });
}


#pragma mark - <UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.prizeDatasArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    PrizeListCollectionViewCell *prizeListCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"PrizeListCollectionViewCell" forIndexPath:indexPath];
    prizeListCell.prizeModel = self.prizeDatasArray[indexPath.item];
    return prizeListCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.isQualified) {
        PrizeListCollectionViewCell *cell = (PrizeListCollectionViewCell *)[collectionView cellForItemAtIndexPath:indexPath];
        for (PrizeListModel *model in self.prizeDatasArray) {
            model.isSelect = NO;
        }
        for (PrizeListCollectionViewCell *cell in self.prizeListCollectionView.visibleCells) {
            cell.isSelectButton.selected = NO;
        }
        PrizeListModel *model = self.prizeDatasArray[indexPath.item];
        cell.isSelectButton.selected = YES;
        model.isSelect = cell.isSelectButton.selected;
    }else {
        [XBLoadingView showHUDViewWithText:@"没有兑换资格"];
    }
}

#pragma mark - 申请兑奖
- (IBAction)applyExchangeButton:(UIButton *)sender {
    
    NSMutableArray *selectArray = [NSMutableArray array];
    for (PrizeListModel *model in self.prizeDatasArray) {
        if (model.isSelect) {
            [selectArray addObject:model];
        }
    }
    if (!selectArray.count) {
        [XBLoadingView showHUDViewWithText:@"未选中任何礼品"];return;
    }
    ApplyPrizeViewController *applyPrizeVC = [[ApplyPrizeViewController alloc]init];
    WS(weakSelf);
    [applyPrizeVC setRequestFinishBlock:^{
        [weakSelf.prizeListCollectionView.mj_header beginRefreshing];
    }];
    applyPrizeVC.preferredContentSize = applyPrizeVC.view.mj_size;
    applyPrizeVC.selectArray = selectArray;
    applyPrizeVC.modalPresentationStyle = UIModalPresentationFormSheet;
    UIPopoverPresentationController *pop = applyPrizeVC.popoverPresentationController;
    pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
    pop.sourceView = applyPrizeVC.view;
    [self presentViewController:applyPrizeVC animated:YES completion:nil];
}

#pragma mark - 兑换记录
- (IBAction)exchangeRecordButton:(UIButton *)sender {
    
    IntegralDetailsViewController *prizeDetails = [[[self class] getGuideIntegralStoryboardClass] instantiateViewControllerWithIdentifier:@"IntegralDetailsViewController"];
    prizeDetails.cellType = PrizeTableView;
    [self.navigationController pushViewController:prizeDetails animated:YES];
}


#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据~" attributes:nil];
}

#pragma mark - lazy
- (NSMutableArray *)prizeDatasArray
{
    if (!_prizeDatasArray) {
        _prizeDatasArray = [NSMutableArray array];
    }
    return _prizeDatasArray;
}

- (PrizeCondition *)queryPrizeModel
{
    if (!_queryPrizeModel) {
        _queryPrizeModel = [[PrizeCondition alloc]init];
        DataPage *page = [[DataPage alloc]init];
        page.page = ONE;
        page.rows = KROWS;
        _queryPrizeModel.page = page;
    }
    return _queryPrizeModel;
}


@end
