
//
//  CustomTabbarController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomTabbarController.h"
#import "Toolview.h"
#import "AppDelegate.h"
#import "SceneLibraryViewController.h"
#import "ProductLibraryViewController.h"
#import "AboutViewController.h"
#import "AllCustomerViewController.h"
#import "CustomerOrderViewController.h"
#import "UserViewController.h"
#import "ChangePasswordViewController.h"
#import "SearchViewController.h"
#import "BaseViewController.h"
#import "QRViewController.h"
#import "ExperienceCentreViewController.h"
#import "RebateViewController.h"
#import "GuideIntegralViewController.h"
#import "LearningCenterMainViewController.h"
#import "AnnouncementViewController.h"
#import "MessageViewController.h"
#import "HomeViewController.h"


@interface CustomTabbarController ()<TabbarButtonClickdelegate,ChangpasswordDelegate,CancelButtondelegate,UITextFieldDelegate>

@property (nonatomic,strong) NSArray *identifierArray;

/**
 *  保存按钮引用
 */
@property (nonatomic,strong) UIButton *Newbutton;

/**
 *  控制器数组
 */
@property (nonatomic,strong) NSMutableArray *vcArray;

/**
 *  工具栏
 */
@property (nonatomic,strong) Toolview *toolview;

@end

@implementation CustomTabbarController

/**
 *  UIStoryboard Identifier数组
 *
 *  @return NSArary
 */
- (NSArray *)identifierArray
{
    if (_identifierArray == nil) {
        
        _identifierArray = [NSArray arrayWithObjects:@"HomeViewController",@"SearchViewController",@"ShoppingViewController",@"ClientViewController",@"RebateViewController",@"GuideIntegralViewController",@"AnnouncementViewController",@"MessageViewController",@"SceneLibraryViewController",@"ProductLibraryViewController",@"AllCustomerViewController",@"CustomerOrderViewController",@"LearningCenterMainViewController",@"AboutViewController", nil];
    }
    return _identifierArray;
}

- (NSMutableArray *)vcArray
{
    if (!_vcArray) {
        _vcArray = [NSMutableArray array];
    }
    return _vcArray;
}


-(void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self.selectedViewController beginAppearanceTransition: YES animated: animated];
}

-(void) viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self.selectedViewController endAppearanceTransition];
}

-(void) viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self.selectedViewController beginAppearanceTransition: NO animated: animated];
}

-(void) viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    [self.selectedViewController endAppearanceTransition];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self addViewcontroller];
    [self addNSNotification];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.tabBar.frame = CGRectMake(ZERO, ZERO, ScreenWidth, NavigationHeight);
    self.toolview = [[Toolview alloc]initWithFrame:CGRectMake(ZERO, ZERO, ScreenWidth, NavigationHeight)];
    self.toolview.delegate = self;
    self.toolview.inputField.delegate = self;
    self.delegate = self;
    [self.view addSubview:self.toolview];
    self.tabBar.hidden = YES;
}

#pragma mark -监听通知
- (void)addNSNotification
{
    //显示体验中心
    [Notification addObserver:self selector:@selector(showFollowHeart:) name:OPENFOLLOWHEARTVC object:nil];
    //显示消息界面
    [Notification addObserver:self selector:@selector(showMessageController:) name:NSNOTIFICATION_MESSAGE object:nil];
    
    //app未启动点击通知回调
    NSDictionary *dict = [UserDefault objectForKey:NSNOTIFICATION_MESSAGE];
    if (dict) {
        self.selectedIndex = 6;
        [Notification postNotificationName:NSNOTIFICATION_MESSAGE object:dict];
        [UserDefault removeObjectForKey:NSNOTIFICATION_MESSAGE];
    }
}

#pragma mark -显示消息界面
- (void)showMessageController:(NSNotification *)object
{
    self.selectedIndex = 6;
}

#pragma mark -添加controller到viewControllers
- (void)addViewcontroller
{
    NSMutableArray *controllerArray = [NSMutableArray array];
    UIStoryboard *storyboard = nil;
    for (int i=0; i<self.identifierArray.count; i++) {
        
        NSString *controllString = self.identifierArray[i];
        // 公告
        if ([controllString isEqualToString:@"AnnouncementViewController"] || [controllString isEqualToString:@"MessageViewController"]) {
            storyboard = [BaseViewController getAnnouncementStoryboardClass];
        }else if ([controllString isEqualToString:@"LearningCenterMainViewController"]) {
            // 学习中心
            storyboard = [BaseViewController getLearningCenterStoryboardClass];
        }else if ([controllString isEqualToString:@"GuideIntegralViewController"]) {
            // 积分
            storyboard = [BaseViewController getGuideIntegralStoryboardClass];
        }else {
            storyboard = [BaseViewController getMainStoryboardClass];
        }
        BaseViewController *control = [storyboard instantiateViewControllerWithIdentifier:self.identifierArray[i]];
        UINavigationController *nav = [[UINavigationController alloc]initWithRootViewController:control];
        [self.vcArray addObject:nav];
        [controllerArray addObject:control];
    }
    self.viewControllers = self.vcArray;
    SHARED_APPDELEGATE.allControllerArray = controllerArray;
    SHARED_APPDELEGATE.tabBarController = self;
    self.selectedIndex = 0;
}


#pragma mark -移除系统自带的UITabBarButton
- (void)viewWillLayoutSubviews {
    [super viewWillLayoutSubviews];
    for (UIView *view in self.tabBar.subviews) {
        if ([view isKindOfClass:NSClassFromString(@"UITabBarButton")]) {
            [view removeFromSuperview];
        }
    }
}


#pragma amrk -TabbarButtonClickdelegate代理
- (void)buttonClickAction:(NSInteger)Buttontag withButton:(UIButton *)button
{
    [self.toolview.inputField resignFirstResponder];
    [self dismissViewControllerAnimated:NO completion:nil];
    _Newbutton = button;
    switch (Buttontag) {
            
        case MENU:
            
            [SHARED_APPDELEGATE.mmdrawer toggleDrawerSide:MMDrawerSideRight animated:YES completion:nil];
            
            break;
        case MESSAGE:
        {
            self.selectedIndex = 7;
        }
            break;
        case NOTICE:
        {
            self.selectedIndex = 6;
        }
            break;
        case SHOPPING_GUIDE:
            
        {
            UserViewController *userVC = [[UserViewController alloc]init];
            userVC.delegate = self;
            userVC.preferredContentSize = CGSizeMake(260, 230);
            userVC.modalPresentationStyle = UIModalPresentationPopover;
            UIPopoverPresentationController *pop = userVC.popoverPresentationController;
            pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
            pop.sourceView = userVC.view;
            pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:button];
            [self presentViewController:userVC animated:YES completion:nil];
        }
            break;
        case CUSTOMER:
            
            self.selectedIndex = 3;
            
            break;
        case SHOPPING_CAR:
            //必须设置当前客户才能跳转到购物车
            if (![Shoppersmanager manager].currentCustomer) {
                
                [XBLoadingView showHUDViewWithText:@"必须设置当前客户才能访问购物车"];
            }else{
                
                self.selectedIndex = 2;
            }
            
            break;
        
        default:
            break;
    }
}

#pragma mark -修改密码点击
- (void)changPasswordButtonClick
{
    [self dismissViewControllerAnimated:NO completion:^{
        ChangePasswordViewController *changpassword = [[ChangePasswordViewController alloc]init];
        changpassword.delegate = self;
        changpassword.preferredContentSize = CGSizeMake(260, 180);
        changpassword.modalPresentationStyle = UIModalPresentationPopover;
        UIPopoverPresentationController *pop = changpassword.popoverPresentationController;
        pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
        pop.sourceView = changpassword.view;
        pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:_Newbutton];
        [self presentViewController:changpassword animated:YES completion:nil];
    }];
}


#pragma mark -取消按钮
- (void)cancelButtonClick
{
    [self dismissViewControllerAnimated:NO completion:^{
        UserViewController *userVC = [[UserViewController alloc]init];
        userVC.delegate = self;
        userVC.preferredContentSize = CGSizeMake(260, 230);
        userVC.modalPresentationStyle = UIModalPresentationPopover;
        UIPopoverPresentationController *pop = userVC.popoverPresentationController;
        pop.permittedArrowDirections = UIPopoverArrowDirectionAny;
        pop.sourceView = userVC.view;
        pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:_Newbutton];
        [self presentViewController:userVC animated:YES completion:nil];
    }];
}

#pragma mark -二维码扫描
- (void)qrcodeButtonClick
{
    WS(weakSelf);
    // 判断应用是否有使用相机的权限
    if(![BaseViewController determineCameraPermissions]){
        ShowAlertView(self, @"提示", @"请在iPad的“设置-隐私-相机”选项中，允许欧立方访问你的相机", nil, @"知道了", UIAlertControllerStyleAlert, nil, nil);
    }else {
        QRViewController *qrVC = [[QRViewController alloc] initWithScanCompleteHandler:^(NSString *url) {
            [weakSelf dismissViewControllerAnimated:YES completion:^{
                ProductLibraryViewController *product = [SHARED_APPDELEGATE.allControllerArray objectAtIndex_opple:8];
                product.barcode = url;
                SHARED_APPDELEGATE.lineView.hidden = YES;
                weakSelf.selectedIndex = 8;
            }];
        }];
        dispatch_async(dispatch_get_main_queue(), ^{
            [weakSelf presentViewController:qrVC animated:YES completion:nil];
        });
    }
}


#pragma mark -搜索框代理方法
- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    self.selectedIndex = 1;
    return YES;
}

#pragma mark -Search按钮
- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    if (![BaseViewController isBlankString:textField.text]) {
        [textField resignFirstResponder];
        [Notification postNotificationName:SEARCHSTRING object:textField.text];
    }
    return YES;
}

#pragma mark -自定义选中
- (void)setSelectedIndex:(NSUInteger)selectedIndex
{
    [super setSelectedIndex:selectedIndex];
    [self didSelectNavigationController:[SHARED_APPDELEGATE.allControllerArray objectAtIndex_opple:selectedIndex]];
}

#pragma mark -返回根视图控制器
- (void)didSelectNavigationController:(UIViewController *)viewController
{
    if ([[viewController.navigationController.viewControllers firstObject] isKindOfClass:NSClassFromString(@"UIMoreListController")]){
        [viewController.navigationController popToViewController:viewController.navigationController.viewControllers[1] animated:YES];
    }else{
        [viewController.navigationController popToRootViewControllerAnimated:YES];
    }
}

#pragma mark -  切换tabbar selectedIndex
- (void)switchSelectedIndex:(NSInteger)selectedIndex
{
    [self.toolview switchLineViewOrigin:selectedIndex-100];
}

#pragma mark -推出体验中心控制器
- (void)showFollowHeart:(NSNotification *)objc
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"OppleMain" bundle:nil];
    ExperienceCentreViewController *ExperienceCenter = [storyboard instantiateViewControllerWithIdentifier:@"ExperienceCentre"];
    ExperienceCenter.modalPresentationStyle = UIModalPresentationOverFullScreen;
    UIPopoverPresentationController *popover = ExperienceCenter.popoverPresentationController;
    popover.sourceView = ExperienceCenter.view;
    [self presentViewController:ExperienceCenter animated:YES completion:nil];
}


@end
