//
//  ResellerViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/6.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "ResellerViewController.h"
#import "CustomWKWebViewController.h"


@interface ResellerViewController ()<UITextFieldDelegate>

@end

@implementation ResellerViewController

- (void)viewDidLoad {
    [super viewDidLoad];

}

#pragma mark -保存经销商ID  ->验证
- (void)modifyResellerInformation
{
    NSString *storeNumber = self.storeNumberTextField.text;
    if ([[self class] isBlankString:storeNumber]) {
        [XBLoadingView showHUDViewWithText:@"输入无效"];return;
    }
    if ([storeNumber isEqualToString:@"无"]) {
        [self saveResellerInformation:storeNumber];return;
    }
    //验证
    NSDictionary *dict = @{@"mfcode":storeNumber};
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    [HTTP networkWithDictionaryRequestWithURL:RESELLER withRequestType:GET withParameter:dict withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToString:@"1"]) {
            [XBLoadingView showHUDViewWithSuccessText:@"验证成功" completeBlock:^{
                [weakSelf saveResellerInformation:storeNumber];
            }];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"msg"]];
        }
        
    } withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark -保存经销商门店编号
- (void)saveResellerInformation:(NSString *)storeCode
{
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    TOResellerstoreEntity *entity = [[TOResellerstoreEntity alloc] init];
    entity.createDate = [[NSDate date] httpParameterString];
    entity.storecode =  storeCode;
    entity.resellerid = [Shoppersmanager manager].shoppers.employee.currentDepart.fid;
    [HTTP networkRequestWithURL:SERVERREQUESTURL(SAVERESELLER) withRequestType:POST withParameter:entity withReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if (RESPONSE(returnValue)) {
            [XBLoadingView showHUDViewWithSuccessText:@"绑定成功" completeBlock:^{
                if ([weakSelf.delegate respondsToSelector:@selector(storeCodeBindedSuccess)]) {
                    [weakSelf.delegate storeCodeBindedSuccess];
                }
                [weakSelf dismissViewControllerAnimated:YES completion:nil];
            }];
        }else {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
        
    } withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}


#pragma mark -帮助按钮
- (IBAction)helpButtonClickAction:(UIButton *)sender {
    
    CustomWKWebViewController *webView = [[CustomWKWebViewController alloc] init];
    webView.type = Image;
    webView.urlString = [[NSBundle mainBundle] pathForResource:@"reference" ofType:@"png"];
    [self presentViewController:webView animated:YES completion:nil];
}


#pragma mark -确认按钮
- (IBAction)sureButtonClickAction:(UIButton *)sender {
    
    [self.storeNumberTextField resignFirstResponder];
    [self modifyResellerInformation];
}



















@end
