//
//  OrderRecordViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OrderRecordViewController.h"
#import "OrderdetailsViewController.h"
#import "OrderTableViewCell.h"

@interface OrderRecordViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

/**
 *  记录总页数
 */
@property (nonatomic,assign) NSInteger totalPage;

/**
 *  订单记录数据
 */
@property (nonatomic,strong) NSMutableArray *orderRecordArray;

/**
 *  请求订单记录
 */
@property (nonatomic,strong) OrderFilter *orderRecordModel;

@end

@implementation OrderRecordViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    [self GetdatasAciton];
}

#pragma mark -获取数据
- (void)GetdatasAciton
{
    WS(weakSelf);
    //下拉刷新
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        //购物袋
        weakSelf.orderRecordModel.dp.page = 1;
        [weakSelf.orderRecordTableView.mj_footer resetNoMoreData];
        [weakSelf getGuideAllcustomerOrder:weakSelf.orderRecordModel isRemove:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.orderRecordTableView.mj_header = headerRefresh;
    //进入刷新状态
    [self.orderRecordTableView.mj_header beginRefreshing];
    //上拉加载
    self.orderRecordTableView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        
        [weakSelf.orderRecordTableView.mj_footer resetNoMoreData];
        //购物袋
        if (++ weakSelf.orderRecordModel.dp.page > weakSelf.totalPage) {
            [weakSelf.orderRecordTableView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            [weakSelf getGuideAllcustomerOrder:weakSelf.orderRecordModel isRemove:NO];
        }
    }];
    self.orderRecordTableView.mj_footer.automaticallyHidden = YES;
    self.orderRecordTableView.tableFooterView = [UIView new];
}


#pragma mark -获取客户订单数据
- (void)getGuideAllcustomerOrder:(OrderFilter *)allOrder isRemove:(BOOL)remove
{
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
    [HTTP networkRequestWithURL:SERVERREQUESTURL(QUERYORDER)  withRequestType:ZERO withParameter:allOrder withReturnValueBlock:^(id returnValue) {
        
        weakSelf.orderRecordTableView.emptyDataSetSource = weakSelf;
        weakSelf.orderRecordTableView.emptyDataSetDelegate = weakSelf;
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.orderRecordTableView];
        if (RESULT(returnValue)) {
            if (remove) {
                [weakSelf.orderRecordArray removeAllObjects];
            }
            OrderResponse *Allorder = [[OrderResponse alloc]initWithDictionary:RESPONSE(returnValue) error:nil];
            weakSelf.totalPage = [RESPONSE(returnValue)[@"totalpages"] intValue];
            for (OrderBill *model in Allorder.orderBillList) {
                [weakSelf.orderRecordArray addObject:model];
            }
            [weakSelf.orderRecordTableView reloadData];
        }else
        {
            [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
        }
    }withFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    OrderTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ordercell" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.model = [self.orderRecordArray objectAtIndex_opple:indexPath.row];
    return  cell;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.orderRecordArray.count;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 200;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    OrderdetailsViewController *orderdetails = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"orderdetails"];
    TOOrderEntity *model = (TOOrderEntity *)[[self.orderRecordArray objectAtIndex_opple:indexPath.row] order];
    orderdetails.orderCode = model.orderNumber;
    if ([model.orderState isEqualToString:@"006"] || [model.orderState isEqualToString:@"002"] || [model.orderState isEqualToString:@"003"]) {
        orderdetails.isShowPrintButton = YES;
        orderdetails.isShowPayButton = NO;
        orderdetails.isShowHeaderView = YES;
        orderdetails.isUserInteractionEnabled = NO;
        
    } else if ([model.orderState isEqualToString:@"001"]) {//未付款
        orderdetails.isShowPayButton = YES;
        orderdetails.isShowPrintButton = NO;
        orderdetails.isShowHeaderView = YES;
        orderdetails.isUserInteractionEnabled = YES;
        
    }else{
        orderdetails.isShowHeaderView = NO;
    }
    //撤销、支付回调
    WS(weakSelf);
    [orderdetails setDelecteAndPayButtonBlock:^(NSInteger cellindex, NSString *orderSate) {
        OrderBill *model = [weakSelf.orderRecordArray objectAtIndex_opple:cellindex];
        model.order.orderState = orderSate;
        NSIndexPath *indexapath = [NSIndexPath indexPathForRow:cellindex inSection:0];
        [weakSelf.orderRecordTableView reloadRowsAtIndexPaths:@[indexapath] withRowAnimation:UITableViewRowAnimationNone];
    }];
    [self.navigationController pushViewController:orderdetails animated:YES];
}

#pragma mark - lazy
- (NSMutableArray *)orderRecordArray
{
    if (_orderRecordArray == nil) {
        
        _orderRecordArray = [NSMutableArray array];
    }
    return _orderRecordArray;
}

- (OrderFilter *)orderRecordModel
{
    if (!_orderRecordModel) {
        _orderRecordModel = [[OrderFilter alloc]init];
        DataPage *Newpage = [[DataPage alloc]init];
        Newpage.page = 1;
        Newpage.rows = KROWS;
        _orderRecordModel.dp = Newpage;
        _orderRecordModel.consumerIdEquals = self.model.fid;
    }
    return _orderRecordModel;
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
