//
//  LocationViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2017/3/21.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "LocationViewController.h"
#import "MOFSPickerManager.h"

@interface LocationViewController ()



@end

@implementation LocationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
}

#pragma mark -选择地址
- (IBAction)chooseLocationButtonClickAction:(UIButton *)sender {

    [[MOFSPickerManager shareManger] showMOFSAddressPickerWithTitle:@"选择城市" cancelTitle:@"取消" commitTitle:@"完成" commitBlock:^(NSString *address, NSString *zipcode) {
        
        [sender setTitle:address forState:UIControlStateNormal];
    } cancelBlock:^{
        
    }];
}

#pragma mark -确认
- (IBAction)affirmButtonClickAction:(UIButton *)sender {
    
    NSArray *addressArray = [[self.chooseLocationButton currentTitle] componentsSeparatedByString:@"-"];
    if (addressArray.count < 3) {
        [XBLoadingView showHUDViewWithText:@"请选择所在区域"];return;
    }
    WS(weakSelf);
    ShowDefaultAlertView(self, @"提示", @"确认后不可更改,请检查是否正确", UIAlertControllerStyleAlert, ^{
        [XBLoadingView showHUDViewWithDefault];
        ToStoreAddress *address = [[ToStoreAddress alloc] init];
        address.resellerid = [Shoppersmanager manager].shoppers.employee.currentDepart.fid;
        address.storecode = [Shoppersmanager manager].shoppers.storeCode;
        address.createDate = [[NSDate date] httpParameterString];
        address.province = addressArray[0];
        address.city = addressArray[1];
        address.country = addressArray[2];
        [HTTP networkRequestWithURL:SERVERREQUESTURL(ADDRESS) withRequestType:POST withParameter:address withReturnValueBlock:^(id returnValue) {
            
            [XBLoadingView hideHUDViewWithDefault];
            if (RESULT(returnValue)) {
                [XBLoadingView showHUDViewWithSuccessText:@"保存成功" completeBlock:^{
                    [weakSelf dismissViewControllerAnimated:YES completion:nil];
                }];

            }else {
                [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
            }
            
        } withFailureBlock:^(NSError *error) {
            [XBLoadingView showHUDViewWithText:error.localizedDescription];
        }];
    }, nil);
}
















@end
