//
//  ForumItemTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumItemTableViewCell.h"

@implementation ForumItemTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    self.backgroundColor = RGB(237, 238, 239, 1);
}

/**
 刷新cell
 
 @param indexPath 下标
 @param topicEntity 实体
 @param delegate 代理
 */
- (void)refreshCell:(NSIndexPath *)indexPath withTopicEntity:(CustomTOForumTopicEntity *)topicEntity withDelegate:(id<TapClickImageViewDelegate>)delegate
{
    self.contentLabel.textColor = topicEntity.isRead?[UIColor grayColor]:[UIColor blackColor];
    self.titleLabel.textColor = topicEntity.isRead?[UIColor grayColor]:[UIColor blackColor];
    self.titleLabel.text = topicEntity.title;
    self.contentLabel.text = topicEntity.content;
    self.userNameLabel.text = topicEntity.posterName;
    self.postCreateTimeLabel.text = [NSString stringWithFormat:@"%@",[BaseViewController formateDate:topicEntity.postTime]];
    self.commentsNumberLabel.text = [NSString stringWithFormat:@"%ld",topicEntity.replyCount];
    self.praiseNumberLabel.text = [NSString stringWithFormat:@"%ld",topicEntity.likeCount];
    self.imageBackView.hidden = topicEntity.attachments.count?NO:YES;
    if (topicEntity.attachments.count) {
        self.imageBackView.imageArray = topicEntity.attachments;
    }
    self.imageBackView.indexPath = indexPath;
    if (topicEntity.backEnd) {
        self.headerImageView.image = TCImage(@"manager");
    }else {
        [self.headerImageView sd_setImageWithURL:[NSURL URLWithString:topicEntity.posterPicture] placeholderImage:TCImage(@"user")];
    }
}

@end
