//
//  ForumItemTableViewCell.h
//  Lighting
//
//  Created by 曹云霄 on 2016/12/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface ForumItemTableViewCell : UITableViewCell


/**
 帖子标题
 */
@property (weak, nonatomic) IBOutlet UILabel *titleLabel;

/**
 发布者名字
 */
@property (weak, nonatomic) IBOutlet UILabel *userNameLabel;

/**
 发布人头像
 */
@property (weak, nonatomic) IBOutlet UIImageView *headerImageView;

/**
 内容
 */
@property (weak, nonatomic) IBOutlet UILabel *contentLabel;

/**
 评论数量
 */
@property (weak, nonatomic) IBOutlet UILabel *commentsNumberLabel;

/**
 帖子创建时间
 */
@property (weak, nonatomic) IBOutlet UILabel *postCreateTimeLabel;

/**
 背景View
 */
@property (weak, nonatomic) IBOutlet UIView *contentBackView;

/**
 赞数量
 */
@property (weak, nonatomic) IBOutlet UILabel *praiseNumberLabel;

/**
 图片背景
 */
@property (weak, nonatomic) IBOutlet CustomImageBackView *imageBackView;


/**
 刷新cell

 @param indexPath 下标
 @param topicEntity 实体
 @param delegate 代理
 */
- (void)refreshCell:(NSIndexPath *)indexPath withTopicEntity:(CustomTOForumTopicEntity *)topicEntity withDelegate:(id<TapClickImageViewDelegate>)delegate;


@end
