//
//  CommentListTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/12.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CommentListTableViewCell.h"

@implementation CommentListTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    
    self.bestView = [[BestReplyView alloc] init];
    [self.contentView addSubview:self.bestView];
    [self.bestView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.optionButton.mas_left).offset(-5);
        make.size.mas_equalTo(CGSizeMake(0, 30));
        make.centerY.equalTo(self.optionButton);
    }];
}

#pragma mark - 选项按钮
- (IBAction)extensionButtonClickAction:(UIButton *)sender {
    if (self.bestView.width != 0) {
        [UIView animateWithDuration:0.2 animations:^{
            self.bestView.width = 0;
            self.bestView.x = self.optionButton.x;
        }];
    }else {
        [UIView animateWithDuration:0.2 animations:^{
            self.bestView.width = 90;
            self.bestView.x -= 100;
        }];
    }
}

#pragma mark - 赋值
- (void)setReplyEntity:(CustomTOForumReplyEntity *)replyEntity
{
    _replyEntity = replyEntity;
    self.bestView.replyId = _replyEntity.fid;
    [self.issuerImageView sd_setImageWithURL:[NSURL URLWithString:_replyEntity.replyerPicture] placeholderImage:CoustomerReplaceImage];
    self.issuerNameLabel.text = [NSString stringWithFormat:@"%@: %@",_replyEntity.replyerPosition,_replyEntity.replyerRealName];
    self.issuerDateLabel.text = [BaseViewController formateDate:_replyEntity.replyTime];
    self.commentContentLabel.text = _replyEntity.replyContent;
    self.bestView.isBest = _replyEntity.best;
    self.bestView.indexPath = self.indexPath;
    self.baseImageView.hidden = !_replyEntity.best;
}

@end
