//
//  HomeViewController.h
//  Lighting
//
//  Created by 曹云霄 on 2017/3/1.
//  Copyright © 2017年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"
#import "iCarousel.h"


/**
 类型

 - ExperienceCentre: 体验中心
 - ProductLibrary: 产品库
 - StudyGuides: 导购学习
 - CustomerInformation: 客户信息
 */
typedef NS_ENUM(NSInteger,MENUCOLLECTIONVIEW_TYPE){
    
    ExperienceCentre = 0,
    ProductLibrary,
    StudyGuides,
    CustomerInformation
};


@interface HomeViewController : BaseViewController


/**
 滚动视图
 */
@property (weak, nonatomic) IBOutlet iCarousel *customScorllView;

/**
 视图模糊背景
 */
@property (weak, nonatomic) IBOutlet UIImageView *scrollViewBackView;


/**
 菜单列表
 */
@property (weak, nonatomic) IBOutlet UICollectionView *menuCollectionView;
@property (weak, nonatomic) IBOutlet UICollectionViewFlowLayout *menuFlowLayout;


/**
 功能列表
 */
@property (weak, nonatomic) IBOutlet UICollectionView *functionCollectionView;
@property (weak, nonatomic) IBOutlet UICollectionViewFlowLayout *functionFlowLayout;



@end
