//
//  ShareGoodsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/3.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShareGoodsViewController.h"

@interface ShareGoodsViewController ()

@end

@implementation ShareGoodsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
}

#pragma mark - 压缩图片
- (void)setShareImage:(UIImage *)shareImage
{
    _shareImage = [UIImage imageWithData:UIImageJPEGRepresentation(shareImage, 0.2)];
}

#pragma mark -分享
- (IBAction)ShareWeiChatAntWeiboAction:(UIButton *)sender {
    
    WS(weakSelf);
    switch (self.type) {
            case SHARE_GOODS:
        {
            NSData *imageData = UIImageJPEGRepresentation(self.shareImage, 0.5);
            NSString *goodsID = [self.shareID substringToIndex:[self.shareID length]-1];
            NSDictionary *parameterDict = [NSDictionary dictionaryWithObjectsAndKeys:[goodsID substringToIndex:self.shareID.length-1],@"goodsIds",@"",@"title",@"",@"remark",nil];
            XBLoadingView *progressView = [XBLoadingView showHUDViewProgressLabel:@"上传图片中"];
            [HTTP uploadImageWithURL:SERVERREQUESTURL(SHARE) withRequestType:ZERO withImageDatas:imageData withParameter:parameterDict withReturnValueBlock:^(id returnValue) {
                
                if (RESULT(returnValue)) {
                    NSString *shareWeb = RESPONSE(returnValue)[@"url"];
                    [self callSharePlatform:shareWeb withPlatformTag:sender withTitle:ShareTitle];
                }else
                {
                    [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
                }
            }withprogressBlock:^(double progress) {
                if (progress >= 1) {
                    dispatch_async(dispatch_get_main_queue(), ^{
                        progressView.labelText = @"上传成功";
                        [progressView hide:YES];
                    });
                    
                }else{
                    progressView.progress = progress;
                }
                
            } withFailureBlock:^(NSError *error) {
                [XBLoadingView hideHUDViewWithDefault];
                [XBLoadingView showHUDViewWithText:error.localizedDescription];
            }];
        }
            break;
            case SHARE_ORDER:
        {
            [XBLoadingView showHUDViewWithDefault];
            NSString *shareOrderString = [NSString stringWithFormat:@"%@/%@",SHAREORDERBILL,self.shareID];
            [HTTP networkWithDictionaryRequestWithURL:SERVERREQUESTURL(shareOrderString) withRequestType:ZERO withParameter:nil withReturnValueBlock:^(id returnValue) {
                
                [XBLoadingView hideHUDViewWithDefault];
                if (RESULT(returnValue)) {
                    [weakSelf callSharePlatform:RESPONSE(returnValue)[@"url"] withPlatformTag:sender withTitle:@"欧立方订单一键分享"];
                }else
                {
                    [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
                }
                
            } withFailureBlock:^(NSError *error) {
                [XBLoadingView hideHUDViewWithDefault];
                [XBLoadingView showHUDViewWithText:error.localizedDescription];
            }];
        }
            break;
            case SHARE_INVITATION:
        {
            [XBLoadingView showHUDViewWithDefault];
            NSString *string = [NSString stringWithFormat:SHAREINVITATION,self.shareID];
            [HTTP networkWithDictionaryRequestWithURL:SERVERREQUESTURL(string) withRequestType:ZERO withParameter:nil withReturnValueBlock:^(id returnValue) {
                
                [XBLoadingView hideHUDViewWithDefault];
                if (RESULT(returnValue)) {
                    [weakSelf callSharePlatform:RESPONSE(returnValue)[@"url"] withPlatformTag:sender withTitle:@"欧立方论坛一键分享"];
                }else
                {
                    [XBLoadingView showHUDViewWithText:MESSAGE(returnValue)];
                }
                
            } withFailureBlock:^(NSError *error) {
                [XBLoadingView hideHUDViewWithDefault];
                [XBLoadingView showHUDViewWithText:error.localizedDescription];
            }];
        }
            break;
        default:
            break;
    }
}

#pragma mark - 调用分享
- (void)callSharePlatform:(NSString *)shareWeb withPlatformTag:(UIButton *)sender withTitle:(NSString *)title
{
    switch (sender.tag) {
        case 100: //微信好友
        {//自定义样式
            //使用UMShareToWechatSession,UMShareToWechatTimeline,UMShareToWechatFavorite分别代表微信好友、微信朋友圈、微信收藏
            [UMSocialData defaultData].extConfig.wechatSessionData.url = shareWeb;
            [[UMSocialDataService defaultDataService]  postSNSWithTypes:@[UMShareToWechatSession] content:title image:self.shareImage location:nil urlResource:nil presentedController:self completion:^(UMSocialResponseEntity *response){
                if (response.responseCode == UMSResponseCodeSuccess) {
                    [XBLoadingView showHUDViewWithSuccessText:@"分享微信好友成功" completeBlock:nil];
                }
            }];
        }
            break;
        case 101://微信朋友圈
        {
            //使用UMShareToWechatSession,UMShareToWechatTimeline,UMShareToWechatFavorite分别代表微信好友、微信朋友圈、微信收藏
            [UMSocialData defaultData].extConfig.wechatTimelineData.url = shareWeb;
            [[UMSocialDataService defaultDataService]  postSNSWithTypes:@[UMShareToWechatTimeline] content:title image:self.shareImage location:nil urlResource:nil presentedController:self completion:^(UMSocialResponseEntity *response){
                if (response.responseCode == UMSResponseCodeSuccess) {
                    [XBLoadingView showHUDViewWithSuccessText:@"分享微信朋友圈成功" completeBlock:nil];
                }
            }];
        }
            break;
        case 102://新浪微博
        {
            //自定义分享样式
            [UMSocialData defaultData].extConfig.sinaData.shareText = [NSString stringWithFormat:@"%@%@",@"欧普照明",shareWeb];
            [[UMSocialDataService defaultDataService]  postSNSWithTypes:@[UMShareToSina] content:title image:self.shareImage location:nil urlResource:nil presentedController:self completion:^(UMSocialResponseEntity *shareResponse){
                if (shareResponse.responseCode == UMSResponseCodeSuccess) {
                    [XBLoadingView showHUDViewWithSuccessText:@"分享新浪微博成功" completeBlock:nil];
                }
            }];
        }
            break;
        default:
            break;
    }
}


@end
