//
//  HelpController.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "HelpController.h"



@interface HelpController ()<UIGestureRecognizerDelegate>

/**
 *  帮助文本
 */
@property (nonatomic,strong) NSArray *helpTitleArray;

@end

@implementation HelpController


- (NSArray *)helpTitleArray
{
    if (!_helpTitleArray) {
        
        _helpTitleArray = [NSArray arrayWithObjects:@"返回",@"添加至购物袋",@"分享方案",@"自定义场景",@"全屏",@"帮助",@"选择场景",@"选择产品", nil];
    }
    return _helpTitleArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.view.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    for (int i=0; i<self.helpTitleArray.count; i++) {
        UIButton *helpButton = [UIButton buttonWithType:UIButtonTypeCustom];
        UIImage *helpImage =  [TCImage(@"lefttool1") resizableImageWithCapInsets:UIEdgeInsetsMake(30, 30, 30, 30) resizingMode:UIImageResizingModeStretch];
        [helpButton setBackgroundImage:helpImage forState:UIControlStateNormal];
        [helpButton setTitleColor:kMainBlueColor forState:UIControlStateNormal];
        NSString *content = [self.helpTitleArray objectAtIndex_opple:i];
        [helpButton setTitle:content forState:UIControlStateNormal];
        helpButton.titleLabel.font = [UIFont systemFontOfSize:15];
        [self.view addSubview:helpButton];
        switch (i) {
            case 0://返回
            {
                    helpButton.frame = CGRectMake(self.backButtonPoint.x+50, self.backButtonPoint.y, [self calculateStringLength:content], 50);
            }
                break;
            case 1://添加至购物车
            {
                   helpButton.frame = CGRectMake(self.shoppingbagPoint.x+50, self.shoppingbagPoint.y, [self calculateStringLength:content], 50);
            }
                break;
            case 2://分享方案
            {
                   helpButton.frame = CGRectMake(self.sharePoint.x+50, self.sharePoint.y, [self calculateStringLength:content], 50);
            }
                break;
            case 3://自定义场景
            {
                   helpButton.frame = CGRectMake(self.photoPoint.x+50, self.photoPoint.y, [self calculateStringLength:content], 50);
            }
                break;
            case 4://全屏
            {
                   helpButton.frame = CGRectMake(self.fullScreenPoint.x+50, self.fullScreenPoint.y, [self calculateStringLength:content], 50);
            }
                break;
            case 5://帮助
            {
                    helpButton.frame = CGRectMake(self.helpPoint.x+50, self.helpPoint.y, [self calculateStringLength:content], 50);
            }
                break;
            case 6://选择场景
            {
                   helpButton.frame = CGRectMake(self.scenePoint.x+40, self.scenePoint.y-20, [self calculateStringLength:content], 50);
            }
                break;
            case 7://选择产品
            {
                UIImage *helpImage =  [TCImage(@"righttool") resizableImageWithCapInsets:UIEdgeInsetsMake(30, 30, 30, 30) resizingMode:UIImageResizingModeStretch];
                [helpButton setBackgroundImage:helpImage forState:UIControlStateNormal];
                helpButton.frame = CGRectMake(self.productPoint.x-[self calculateStringLength:content]-40, self.productPoint.y-20, [self calculateStringLength:content], 50);
            }
                break;
                
            default:
                break;
        }
        
    }
}

#pragma mark -计算字符串长度
- (CGFloat)calculateStringLength:(NSString *)string
{
    return [string widthWithFontSize:15 height:50]+100;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
