//
//  CustomBorderLabel.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/23.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomBorderLabel.h"

@implementation CustomBorderLabel


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.font = [UIFont systemFontOfSize:12];
    }
    return self;
}


- (void)setCustomText:(NSString *)customText
{
    _customText = customText;
    UIColor *color;
    if ([customText isEqualToString:@"行业动态"]) {
        color = RGB(133, 210, 107, 1);
    }else if ([customText isEqualToString:@"品牌资讯"]) {
        color = RGB(0, 127, 210, 1);
    }else if ([customText isEqualToString:@"活动公告"]) {
        color = RGB(241, 171, 0, 1);
    }else if ([customText isEqualToString:@"精华帖"]) {
        color = [UIColor colorWithRed:0.96 green:0.74 blue:0.33 alpha:1.00];
    }else if ([customText isEqualToString:@"置顶"]) {
        color = kMainBlueColor;
    }else if ([customText isEqualToString:@"管理员"]) {
        color = [UIColor redColor];
    }
    self.layer.masksToBounds = YES;
    self.layer.borderWidth = 1.0f;
    self.layer.borderColor = color.CGColor;
    self.layer.cornerRadius = 2.0f;
    self.textColor = color;
    self.text = _customText;
//    //计算宽度，并自动改变
//    CGFloat width = [_customText widthWithFontSize:13 height:16]+10;
//    [self mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.width.mas_equalTo(width);
//        make.height.mas_equalTo(20);
//    }];
}












@end
