//
//  MBProgressView.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/5.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation
import UIKit
import SVProgressHUD


// MARK: - 纯文本显示框
func ShowMessage(_ message: String) {
    SVProgressHUD.showInfo(withStatus: message)
    SVProgressHUD.dismiss(withDelay: 3)
}

// MARK: - 菊花加载框,默认颜色和主题色相同
func ShowLoadingView() {
    SVProgressHUD.setBackgroundLayerColor(kMainColor)
    SVProgressHUD.show()
}

// MARK: - 上传文件中
func ShowProgressView(_ progress: Float) {
    SVProgressHUD.showProgress(progress, status: "附件上传中")
}

// MARK: - 销毁
func HideLoadingView() {
    SVProgressHUD.popActivity()
}













