//
//  TabBarViewController.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/11/29.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit

class TabBarViewController: UITabBarController {

    override func viewDidLoad() {
        super.viewDidLoad()

        addChildViewControllers()
    }
    // MARK: - 添加TabBar控制器
    fileprivate func addChildViewControllers() {
        setTabBarItem(HomeViewController.instantiateViewController(.Home), navTitle: "首页", tabBarTitle: "首页", imageName: "home_icon")
        setTabBarItem(FunctionViewController.instantiateViewController(.Function), navTitle: "功能", tabBarTitle: "功能", imageName: "function_icon")
        setTabBarItem(AccountTableViewController.instantiateViewController(.Me), navTitle: "我的", tabBarTitle: "我的", imageName: "me_icon")
    }
    
    /// 创建TabBarItem
    ///
    /// - Parameters:
    ///   - vc: 控制器
    ///   - navTitle: 导航栏标题
    ///   - tabBarTitle: item标题
    ///   - imageName: 图标名字
    ///   - imageName_selected: 选中图标名字
    fileprivate func setTabBarItem(_ vc: UIViewController, navTitle: String?, tabBarTitle: String?, imageName: String?) {
        let image: UIImage? = UIImage(named: imageName!)?.withRenderingMode(.alwaysOriginal)
        let image_selected: UIImage? = UIImage(named: imageName! + "_selected")?.withRenderingMode(.alwaysOriginal)
        let tabBarItem: UITabBarItem = UITabBarItem(title: tabBarTitle, image: image, selectedImage: image_selected)
        let nav: BaseNavigationController = BaseNavigationController(rootViewController: vc)
        vc.tabBarItem = tabBarItem
        vc.navigationItem.title = navTitle
        addChildViewController(nav);
        // 设置默认的选中文字颜色
        UITabBarItem.appearance().setTitleTextAttributes(NSDictionary(object:UIColor.darkGray, forKey:NSAttributedStringKey.foregroundColor as NSCopying) as? [NSAttributedStringKey : AnyObject], for:UIControlState.normal);
        UITabBarItem.appearance().setTitleTextAttributes(NSDictionary(object:kNavColor, forKey:NSAttributedStringKey.foregroundColor as NSCopying) as? [NSAttributedStringKey : AnyObject], for:UIControlState.selected)
        // 设置字体大小
        UITabBarItem.appearance().setTitleTextAttributes([NSAttributedStringKey.font : UIFont(name: "Helvetica", size: 11)!], for: UIControlState.normal)
    }
}
























