//
//  AppManager.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/1.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit
import Hero

class AppManager: NSObject {
    
    /// 登录用户信息
    open var userModel: UserModel?
    /// 用户所属项目
    open var userStoreModel: StoreResultData?

    /// 单例模式
    static var shareInstance: AppManager = {
        let instance = AppManager();
        AppStyle.setupAppStyle()
        return instance;
    }();
    
    // MARK: - 打开主页
    func openMainVc() {
        let tabBarVc: TabBarViewController = TabBarViewController()
        setRootVc(tabBarVc, .transitionCrossDissolve)
    }

    // MARK: - 打开登录页
    func openLoginVc() {
        LoginViewModel.unarchiveAccountInformation()
        guard AppManager.shareInstance.userModel == nil else {
            openMainVc()
            return
        }
        let loginVc = LoginViewController.instantiateViewController(.Main)
        setRootVc(loginVc, .transitionCrossDissolve)
    }
    
    // MARK: - 动画切换根视图控制器
    fileprivate func setRootVc(_ controller: UIViewController,_ options: UIViewAnimationOptions) {
        UIView.transition(with: kWindow, duration: 0.5, options: options, animations: {
            let oldState = UIView.areAnimationsEnabled
            UIView.setAnimationsEnabled(false)
            kWindow.rootViewController = controller
            UIView.setAnimationsEnabled(oldState)
        }, completion: nil)
    }
}

















