//
//  HomeTableViewCell.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class HomeTableViewCell: UITableViewCell {

    /// 部门（代码）
    @IBOutlet weak var departmentLabel: UILabel!
    /// 单据时间
    @IBOutlet weak var orderTimeLabel: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }
    
    // MARK: - 更新待办cell
    func updateTodoCell(_ model: TodoData, _ indexPath: IndexPath) {
        if model.entityType == .work{
            departmentLabel.text = model.workNo
        }else{
            let titleString = model.dept.code != "" ? "(\(model.dept.code ?? ""))" : " "
            departmentLabel.text = model.dept.name + titleString
        }
        orderTimeLabel.text = String(format: "创建时间：%@", model.createTime)
    }

}
