//
//  HomeTableViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import RxCocoa
import SwiftyJSON

class HomeTableViewController: BaseTableViewPullController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    
    /// 待办事项ViewModel
    lazy final var todoViewModel: TodoViewModel = {
       var todoViewModel = TodoViewModel()
        return todoViewModel
    }()
    
    /// 工单详情ViewModel
    lazy final var orderDetailViewModel: RepairOrderDetailViewModel = {
        var orderDetailViewModel = RepairOrderDetailViewModel()
        return orderDetailViewModel
    }()
    
    /// 待办状态
    open var todoState: TODO_STATE!
    
    override func viewDidLoad() {
        super.viewDidLoad()

    }
    
    // MARK: - 获取数据
    override func loadWebDataSource() {
        if !PermissionsManager.todoViewPermissions() {
            endRefresh()
            tableView.reloadData()
            return;
        }
        todoViewModel.queryTodoAction(todoState).subscribe {[weak self] (event) in
            switch event {
            case .next():
                self?.endRefreshNomoreData()
                break
            case .error(_):
                self?.endRefresh()
                break
            default:
                break
            }
            self?.reloadData()
        }.disposed(by: disposeBag)
    }
    func delyLoadData(){
        ShowLoadingView()
        DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + 3) {
            self.loadWebDataSource()
        }
    }
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        return todoViewModel.dequeueReusableHomeCell(HomeTableViewCell.name(), indexPath, tableView)
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return todoViewModel.todoResultArray.count
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 60
    }

    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        let model = todoViewModel.todoResultArray[indexPath.row]
        if model.entityType == .work{
            let detailBgController = UIStoryboard(name: "Function", bundle: nil).instantiateViewController(withIdentifier: RepairOrderDetailBgController.name()) as! RepairOrderDetailBgController
            detailBgController.billModel = RepairOrderRecord(fromJson: JSON(model.toDictionary()))
            detailBgController.billModel.uuid = model.entityUuid
            pushVC(detailBgController)
        }else{
            switch model.workState {
            case TODO_STATE.INIT:
                if !PermissionsManager.drawChildPermissions() {
                    ShowMessage("当前用户对此工单没有领取权限!")
                    return
                }
                ShowAlertView(hint, "请确认是否领单?", [cancel,sure], .alert, {[weak self] (index) in
                    if index == kZERO { return }
                    self?.orderDetailViewModel.getChildBillAction(model.entityUuid).subscribe(onNext: { () in
                        self?.loadWebDataSource()
                        Network.request(target: Service.ChildOrderComplete(model.entityUuid, "drew"), success: { (json) in
                            
                        }, failure: { (error) in
                            
                        })
                        ShowMessage("领取成功")
                        self?.delyLoadData()
                    }).disposed(by: self!.disposeBag)
                })
                break
            case TODO_STATE.DREW:
                if !PermissionsManager.saveChildPermissions() {
                    ShowMessage("当前用户对此工单没有编辑权限!")
                    return;
                }
                let childBillVc = RepairOrderEditSonOrderViewController.instantiateViewController(.Function) as! RepairOrderEditSonOrderViewController
                childBillVc.billModel = BillDetailExecute(fromJson: JSON(model.toDictionary()))
                childBillVc.billModel.uuid = model.entityUuid
                pushVC(childBillVc)
                break
            case TODO_STATE.PROCESSING:
                if !PermissionsManager.childViewPermissions() {
                    ShowMessage("当前用户对此工单没有查看权限!")
                    return;
                }
                let childBillVc = RepairOrderChildBillDetailViewController.instantiateViewController(.Function) as! RepairOrderChildBillDetailViewController
                childBillVc.billModel = BillDetailExecute(fromJson: JSON(model.toDictionary()))
                childBillVc.billModel.uuid = model.entityUuid
                pushVC(childBillVc)
                break
            default:
                break
            }
        }
    }

    override func description(forEmptyDataSet scrollView: UIScrollView!) -> NSAttributedString! {
        let dict: [NSAttributedStringKey: Any] = [NSAttributedStringKey.font: UIFont.systemFont(ofSize: 15),NSAttributedStringKey.foregroundColor: kNavColor]
        let boolValue = PermissionsManager.todoViewPermissions()
        let attrString = NSAttributedString(string: boolValue ? "对不起，真的没有数据!" : "当前用户对待办事项没有查看权限!", attributes: dict)
        return attrString
    }
    
}











