//
//	TodoResultModel.swift
//
//	Create by 云霄 曹 on 9/1/2018

import Foundation 
import SwiftyJSON

class TodoResultModel{

    var data : [TodoData]!
    var message : String!
    var success : Bool!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        data = [TodoData]()
        let dataArray = json["data"].arrayValue
        for dataJson in dataArray{
            let value = TodoData(fromJson: dataJson)
            data.append(value)
        }
        message = json["message"].stringValue
        success = json["success"].boolValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if data != nil{
            var dictionaryElements = [[String:Any]]()
            for dataElement in data {
                dictionaryElements.append(dataElement.toDictionary())
            }
            dictionary["data"] = dictionaryElements
        }
        if message != nil{
            dictionary["message"] = message
        }
        if success != nil{
            dictionary["success"] = success
        }
        return dictionary
    }
}



class TodoData{
    
    enum EntityType:String {
        case work = "work"
        case workExecute = "workExecute"
    }
    var dept: UCN = UCN("", "", "")
    var createTime: String = ""
    var uuid: String = ""
    var version: String = ""
    var state: Bool = false
    var content: String = ""
    var entityType: EntityType = EntityType.work
    var entityUuid: String = ""
    var userid: String = ""
    var workState:TODO_STATE = TODO_STATE.ALL
    var workNo:String = ""
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        createTime = json["createTime"].stringValue
        uuid = json["uuid"].stringValue
        version = json["version"].stringValue
        state = json["state"].boolValue
        content = json["content"].stringValue
        entityType = EntityType(rawValue: json["entityType"].stringValue) ?? EntityType.work
        entityUuid = json["entityUuid"].stringValue
        userid = json["userid"].stringValue
        workState = TODO_STATE(rawValue: json["workState"].stringValue) ?? TODO_STATE.ALL
        workNo = json["workNo"].stringValue
        
        let deptJson = json["dept"]
        if !deptJson.isEmpty{
            dept = UCN(fromJson: deptJson)
        }
    }
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if createTime != ""{
            dictionary["createTime"] = createTime
        }
        if uuid != ""{
            dictionary["uuid"] = uuid
        }
        if version != ""{
            dictionary["version"] = version
        }
        dictionary["state"] = state
        if content != ""{
            dictionary["content"] = content
        }
        dictionary["entityType"] = entityType.rawValue
        if entityUuid != ""{
            dictionary["entityUuid"] = entityUuid
        }
        if userid != ""{
            dictionary["userid"] = userid
        }
        if workNo != ""{
            dictionary["workNo"] = workNo
        }
        if dept.name != nil{
            dictionary["dept"] = dept.toDictionary()
        }
        dictionary["workState"] = workState.rawValue
        return dictionary
    }
    
}
