//
//  RepairOrderDetailViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/12.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import Moya
import SwiftyJSON

class RepairOrderDetailViewModel: BaseViewModel {

    /// 工单详情
    var billDetailModel: BillDetailData!
    
    /// Section Title
    lazy final var sectionArray: Array<String> = {
        var sectionArray = Array<String>()
        sectionArray.append("创建")
        sectionArray.append("创建")
        sectionArray.append("完成处理")
        return sectionArray
    }()
    
    // 主工单完成Model
    var billCompltedModel: BillCompletedRequestModel!
    
}

extension RepairOrderDetailViewModel {
    
    /// 发出工单
    func usefulWorkBillAction(_ billUuid: String) ->Observable<Void> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .UsefulWorkBill(billUuid), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                }
                }, failure: { (error) in
                    ShowMessage(error.localizedDescription)
                    observer.onError(MoyaError.requestMapping(error.localizedDescription))
            })
            return Disposables.create()
        })
    }
    
    /// 查询工单详情
    func queryRepairOrderDetailAction(_ billUuid: String) ->Observable<Void>{
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .GetRepairOrderDetail(billUuid), success: {[weak self] (json) in
                let resultModel = RepairOrderDetailResult(fromJson: json)
                if resultModel.success {
                    if let model = resultModel.data {
                        self?.billDetailModel = model
                        observer.onNext(())
                    }else {
                        ShowMessage(resultModel.message)
                        observer.onError(MoyaError.requestMapping(resultModel.message))
                    }
                }else {
                    ShowMessage(resultModel.message)
                    observer.onError(MoyaError.requestMapping(resultModel.message))
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
                observer.onError(MoyaError.requestMapping(error.localizedDescription))
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 获取照片描述图片附件
    func downloadAttachmentAction(_ entityType: String) ->Observable<[AttachmentData]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .DownloadAttachment(entityType,self.billDetailModel.attachmentId), success: { (json) in
                let resultModel = AttachmentResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 获取位置图图片附件
    func downloadLocationAttAction(_ entityType: String) ->Observable<[AttachmentData]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .DownloadAttachment(entityType,self.billDetailModel.locationAttachmentId), success: { (json) in
                let resultModel = AttachmentResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询工单转交部门
    func queryRepairOrderDepartmentAction(_ model: QueryModel) ->Observable<DepartmentData> {
//        if AppManager.shareInstance.userStoreModel != nil {
            return queryRepairOrderDepartmentAction2()
//        }else {
//            return Observable.create({ (observer) -> Disposable in
//                Network.request(target: .GetRepairOrderDepartment(model), success: { (json) in
//                    let resultModel = DepartmentResultModel(fromJson: json)
//                    if resultModel.success {
//                        observer.onNext(resultModel.data)
//                    }else {
//                        ShowMessage(resultModel.message)
//                    }
//                }, failure: { (error) in
//                    ShowMessage(error.localizedDescription)
//                })
//                return Disposables.create()
//            })
//        }
    }
    
    // MARK: - 查询工单转交部门2(当前登录人所属项目不为空时调用)
    func queryRepairOrderDepartmentAction2() ->Observable<DepartmentData> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryStoreSubOrgs(self.billDetailModel.store.uuid), success: { (json) in
                let resultModel = DepartmentResultModel2(fromJson: json)
                if resultModel.success {
                    let model = DepartmentData(fromJson: json)
                    var array = [UCN]()
                    for model in resultModel.data {
                        let ucnModel = UCN(fromJson: JSON(model.toDictionary()))
                        array.append(ucnModel)
                    }
                    model.records = array
                    observer.onNext(model)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 转交工单
    func transferRepairOrderAction(_ model: DepartmentQueryModel) ->Observable<Void> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .TransferOrder(model), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 完成工单
    func complteRepairOrderAction(_ model: BillCompletedRequestModel) ->Observable<Void> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .CompleteOrder(model), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 领取子工单
    func getChildBillAction(_ childBillUuid: String) ->Observable<Void> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .GetChildBill(childBillUuid), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
}

extension RepairOrderDetailViewModel {
    
    // MARK: - 工单详情赋值
    func billDetailAssignment(_ controller: RepairOrderDetailViewController) {
        var source: String?
        if billDetailModel.source == "租区"  {
            if billDetailModel.tenant != nil {
                source = String(format: "%@，商户: (%@)", billDetailModel.source,billDetailModel.tenant.name)
            }else {
                source = String(format: "%@，商户: ---", billDetailModel.source)
            }
        }else {
            source = String(format: "%@", billDetailModel.source)
        }
        controller.descriptionLab.adjustsFontSizeToFitWidth = true
        controller.remarkLabel.adjustsFontSizeToFitWidth = true
        controller.sourceLab.text = source
        controller.serverTypeLab.text = disposeEmpty(billDetailModel.serviceType)
        controller.priorityLab.text = disposeEmpty(billDetailModel.level)
        if billDetailModel.reportUser != nil {
            controller.userLab.text = disposeEmpty(billDetailModel.reportUser.name)
        }
        controller.phoneLab.text = disposeEmpty(billDetailModel.reporterPhone)
        controller.createTimeLab.text = disposeEmpty(billDetailModel.createTime)
        controller.requestTimeLab.text = disposeEmpty(billDetailModel.requestTime)
        if billDetailModel.device != nil {
            controller.deviceLocationLab.text = disposeEmpty(billDetailModel.deviceadree)
            controller.deviceLab.text = disposeEmpty(billDetailModel.device.name)
            controller.brokenTimeLab.text = disposeEmpty(billDetailModel.brokenTime)
        }
        if billDetailModel.position != nil {
            controller.positionLabel.text = disposeEmpty(billDetailModel.position.name)
        }
        controller.descriptionLab.text = disposeEmpty(billDetailModel.descriptionField)
        controller.billNumberLab.text = billDetailModel.workNo
        controller.isSolveLabel.text = billDetailModel.finish ? "是" : "否"
        controller.remarkLabel.text = disposeEmpty(billDetailModel.note)
        controller.completionLabel.text = disposeEmpty(billDetailModel.finishNote)
        if billDetailModel.store != nil {
            controller.projectLabel.text = disposeEmpty(billDetailModel.store.name)
        }
    }
    
    // MARK: - 处理空数据
    func disposeEmpty(_ string: String) ->String? {
        if string.isEmpty {
            return "---"
        }
        return string
    }
    
    // MARK: - 工单详情状态处理
    func billDetailStataDispose(_ controller: RepairOrderDetailViewController) {
        switch billDetailModel.state {
        case SUBMIT_REPAIR_ORDER_STATE.CREATED.rawValue:
            controller.createdStateImg.image = UIImage(named: "state_selected")
            controller.createStateLab.text = repairOrderChineseState(billDetailModel.state)
            controller.createStateLab.textColor = kBlueColor
            
            controller.processedStateImg.image = UIImage(named: "state_default")
            controller.processedStateLab.textColor = kLightGaryColor
            
            controller.completedStateImg.image = UIImage(named: "state_default")
            controller.completedStateLab.textColor = kLightGaryColor
            break
        case SUBMIT_REPAIR_ORDER_STATE.SUBMIT.rawValue:
            
            controller.createdStateImg.image = UIImage(named: "state_selected")
            controller.createStateLab.textColor = kBlueColor
            
            controller.processedStateImg.image = UIImage(named: "state_default")
            controller.processedStateLab.textColor = kLightGaryColor
            
            controller.completedStateImg.image = UIImage(named: "state_default")
            controller.completedStateLab.textColor = kLightGaryColor
            break
        case SUBMIT_REPAIR_ORDER_STATE.PROCESSING.rawValue:
            
            controller.createdStateImg.image = UIImage(named: "state_default")
            controller.createStateLab.textColor = kLightGaryColor
            
            controller.processedStateImg.image = UIImage(named: "state_selected")
            controller.processedStateLab.textColor = kBlueColor
            
            controller.completedStateImg.image = UIImage(named: "state_default")
            controller.completedStateLab.textColor = kLightGaryColor
            break
        case SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue:
            
            controller.createdStateImg.image = UIImage(named: "state_default")
            controller.createStateLab.textColor = kLightGaryColor
            
            controller.processedStateImg.image = UIImage(named: "state_default")
            controller.processedStateLab.textColor = kLightGaryColor
            
            controller.completedStateImg.image = UIImage(named: "state_selected")
            controller.completedStateLab.textColor = kBlueColor
            break
        default:
            break
        }
    }
    
    // MARK: - 选择转交部门
    func repairOrderDepartmentChoice(_ result: DepartmentData,_ controller: RepairOrderDetailViewController) ->Observable<(String,Array<String>)> {
        return Observable.create({ (observer) -> Disposable in
            let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
            for model in result.records {
                let filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                publicFilterVc.publicViewModel.filterArray.add(filterModel)
            }
            controller.pushVC(publicFilterVc)
            publicFilterVc.setNavigationTitle("选择转交部门",.MULTIPLE, { (choices, index) in
                var array = Array<String>()
                var message = "请确认转交工单给以下部门:\n"
                for model in choices {
                    array.append(model.uuid!)
                    message.append("\n")
                    message.append(model.title)
                    message.append("\n")
                }
                observer.onNext((message,array))
            })
            return Disposables.create()
        })
    }
    
    // MARK: 子工单cell
    func dequeueChildBillReusableCell(_ identifier: String, _ indexPath: IndexPath, _ tableView: UITableView) ->UITableViewCell {
        let childBillCell = tableView.dequeueReusableCell(withIdentifier: identifier, for: indexPath) as! RepairOrderSubOrderTableViewCell
        childBillCell.updateChildBillCell(billDetailModel.executes[indexPath.row], indexPath)
        return childBillCell
    }
    
    // MARK: - 工单详情分区信息
    func dequeueReusableHeaderFooterView(_ identifier: String, _ tableView: UITableView, _ section: Int) ->UIView? {
        let sectionView = tableView.dequeueReusableHeaderFooterView(withIdentifier: RepairOrderDetailSectionView.name()) as! RepairOrderDetailSectionView
        switch section {
        case REPAIR_ORDER_DETAIL_SECTION.SOURCE.rawValue:
            sectionView.sectionStateLabel.text = "创建"
            sectionView.stateTimeLabel.text = billDetailModel.createTime
            break
        case REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue:
            sectionView.sectionStateLabel.text = "创建"
            if billDetailModel.executes != nil {
                sectionView.stateTimeLabel.text = billDetailModel.executes.first?.createTime
            }else {
                sectionView.stateTimeLabel.text = nil
            }
            break
        case REPAIR_ORDER_DETAIL_SECTION.COMPLETED.rawValue:
            sectionView.sectionStateLabel.text = "完成情况"
            sectionView.stateTimeLabel.text = billDetailModel.finishTime
            break
        default:
            break
        }
        return sectionView
    }
}



















