//
//	DepartmentResultModel2.swift
//
//	Create by 云霄 曹 on 1/2/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON


class DepartmentResultModel2 : NSObject{

	var data : [DepartmentResultData]!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [DepartmentResultData]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			let value = DepartmentResultData(fromJson: dataJson)
			data.append(value)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			var dictionaryElements = [[String:Any]]()
			for dataElement in data {
				dictionaryElements.append(dataElement.toDictionary())
			}
			dictionary["data"] = dictionaryElements
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}

}

class DepartmentResultData : NSObject{
    
    var code : String!
    var level : Int!
    var name : String!
    var path : String!
    var upper : String!
    var uuid : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        code = json["code"].stringValue
        level = json["level"].intValue
        name = json["name"].stringValue
        path = json["path"].stringValue
        upper = json["upper"].stringValue
        uuid = json["uuid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if code != nil{
            dictionary["code"] = code
        }
        if level != nil{
            dictionary["level"] = level
        }
        if name != nil{
            dictionary["name"] = name
        }
        if path != nil{
            dictionary["path"] = path
        }
        if upper != nil{
            dictionary["upper"] = upper
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        return dictionary
    }
    
}
