//
//	ChildBillDetailResultModel.swift
//
//	Create by 云霄 曹 on 16/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON


class ChildBillDetailResultModel : NSObject{

	var data : ChildBillDetailData!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = ChildBillDetailData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			dictionary["data"] = data.toDictionary()
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}

open class ChildBillDetailData : NSObject{
    
    var beginAttachmentId : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var dept : UCN!
    var endAttachmentId : String!
    var executeMateriels : [ExecuteMateriel]!
    var executeOutsources : [ExecuteMateriel]!
    var executeNo : String!
    var hasOut : Bool!
    var hasPaid : Bool!
    var labourfee : String!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var materielfee : String!
    var note : String!
    var noteHeight : CGFloat! = 30
    var owner : UCN!
    var ownerTime : String!
    var processBegin : String!
    var processEnd : String!
    var processMode : String!
    var processor : String!
    var property1 : String!
    var property2 : String!
    var reason : String!
    var state : String!
    var uuid : String!
    var version : Int!
    var workid : String!
    
    
    
    init(_ state: String) {
        self.state = state
    }
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        beginAttachmentId = json["beginAttachmentId"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        let deptJson = json["dept"]
        if !deptJson.isEmpty{
            dept = UCN(fromJson: deptJson)
        }
        executeMateriels = [ExecuteMateriel]()
        executeOutsources = [ExecuteMateriel]()
        let executeMaterielsArray = json["executeMateriels"].arrayValue
        for executeMaterielsJson in executeMaterielsArray{
            let value = ExecuteMateriel(fromJson: executeMaterielsJson)
            if value.sourceType == CHILDORDERCOST_TYPE.COST.rawValue {
                executeOutsources.append(value)
            }else {
                executeMateriels.append(value)
            }
        }
        endAttachmentId = json["endAttachmentId"].stringValue
        executeNo = json["executeNo"].stringValue
        hasOut = json["hasOut"].boolValue
        hasPaid = json["hasPaid"].boolValue
        labourfee = json["labourfee"].stringValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        materielfee = json["materielfee"].stringValue
        note = json["note"].stringValue
        noteHeight = note.calculateStringSize(CGSize(width: kWidth - 105, height: CGFloat.greatestFiniteMagnitude), font: UIFont.systemFont(ofSize: 13)).height
        let ownerJson = json["owner"]
        if !ownerJson.isEmpty{
            owner = UCN(fromJson: ownerJson)
        }
        ownerTime = json["ownerTime"].stringValue
        processBegin = json["processBegin"].stringValue
        processEnd = json["processEnd"].stringValue
        processMode = json["processMode"].stringValue
        processor = json["processor"].stringValue
        property1 = json["property1"].stringValue
        property2 = json["property2"].stringValue
        reason = json["reason"].stringValue
        state = json["state"].stringValue
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
        workid = json["workid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if beginAttachmentId != nil{
            dictionary["beginAttachmentId"] = beginAttachmentId
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if dept != nil{
            dictionary["dept"] = dept.toDictionary()
        }
        if endAttachmentId != nil{
            dictionary["endAttachmentId"] = endAttachmentId
        }
        if !executeMateriels.isEmpty {
            dictionary["executeMateriels"] = executeMateriels
        }
        if executeNo != nil{
            dictionary["executeNo"] = executeNo
        }
        if !executeOutsources.isEmpty {
            dictionary["executeOutsources"] = executeOutsources
        }
        if hasOut != nil{
            dictionary["hasOut"] = hasOut
        }
        if hasPaid != nil{
            dictionary["hasPaid"] = hasPaid
        }
        if labourfee != nil{
            dictionary["labourfee"] = labourfee
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if materielfee != nil{
            dictionary["materielfee"] = materielfee
        }
        if note != nil{
            dictionary["note"] = note
        }
        if owner != nil{
            dictionary["owner"] = owner.toDictionary()
        }
        if ownerTime != nil{
            dictionary["ownerTime"] = ownerTime
        }
        if processBegin != nil{
            dictionary["processBegin"] = processBegin
        }
        if processEnd != nil{
            dictionary["processEnd"] = processEnd
        }
        if processMode != nil{
            dictionary["processMode"] = processMode
        }
        if processor != nil{
            dictionary["processor"] = processor
        }
        if property1 != nil{
            dictionary["property1"] = property1
        }
        if property2 != nil{
            dictionary["property2"] = property2
        }
        if reason != nil{
            dictionary["reason"] = reason
        }
        if state != nil{
            dictionary["state"] = state
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        if workid != nil{
            dictionary["workid"] = workid
        }
        return dictionary
    }
}

class ExecuteMateriel : NSObject{
    
    var backQty : Float!
    var batchNo : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var getQty : Float!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var materiel : UCN!
    var outputbillno : String!
    var outputid : String!
    var sourceId : String!
    var sourceType : String!
    var unitPrice : Float!
    var useQty : Float!
    var uuid : String!
    var version : Int!
    var workexecuteid : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        backQty = json["backQty"].floatValue
        batchNo = json["batchNo"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        getQty = json["getQty"].floatValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        let materielJson = json["materiel"]
        if !materielJson.isEmpty{
            materiel = UCN(fromJson: materielJson)
        }
        outputbillno = json["outputbillno"].stringValue
        outputid = json["outputid"].stringValue
        sourceId = json["sourceId"].stringValue
        sourceType = json["sourceType"].stringValue
        unitPrice = json["unitPrice"].floatValue
        useQty = json["useQty"].floatValue
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
        workexecuteid = json["workexecuteid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if backQty != nil{
            dictionary["backQty"] = backQty
        }
        if batchNo != nil{
            dictionary["batchNo"] = batchNo
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if getQty != nil{
            dictionary["getQty"] = getQty
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if materiel != nil{
            dictionary["materiel"] = materiel.toDictionary()
        }
        if outputbillno != nil{
            dictionary["outputbillno"] = outputbillno
        }
        if outputid != nil{
            dictionary["outputid"] = outputid
        }
        if sourceId != nil{
            dictionary["sourceId"] = sourceId
        }
        if sourceType != nil{
            dictionary["sourceType"] = sourceType
        }
        if unitPrice != nil{
            dictionary["unitPrice"] = unitPrice
        }
        if useQty != nil{
            dictionary["useQty"] = useQty
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        if workexecuteid != nil{
            dictionary["workexecuteid"] = workexecuteid
        }
        return dictionary
    }
    
}
