//
//	RootClass.swift
//
//	Create by 云霄 曹 on 15/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON


class AttachmentReponseModel : NSObject{

	var data : [AttachmentReponseData]!
	var message : String!
	var success : Bool!

	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [AttachmentReponseData]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			let value = AttachmentReponseData(fromJson: dataJson)
			data.append(value)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			var dictionaryElements = [[String:Any]]()
			for dataElement in data {
				dictionaryElements.append(dataElement.toDictionary())
			}
			dictionary["data"] = dictionaryElements
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}


class AttachmentReponseData : NSObject{
    
    var entityType : String!
    var entityUuid : String!
    var fileName : String!
    var fileUrl : AnyObject!
    var lastModified : AnyObject!
    var thumbnailFileName : AnyObject!
    var uuid : String!

    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        entityType = json["entityType"].stringValue
        entityUuid = json["entityUuid"].stringValue
        fileName = json["fileName"].stringValue
        fileUrl = json["fileUrl"] as AnyObject
        lastModified = json["lastModified"] as AnyObject
        thumbnailFileName = json["thumbnailFileName"] as AnyObject
        uuid = json["uuid"].stringValue
    }

    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if entityType != nil{
            dictionary["entityType"] = entityType
        }
        if entityUuid != nil{
            dictionary["entityUuid"] = entityUuid
        }
        if fileName != nil{
            dictionary["fileName"] = fileName
        }
        if fileUrl != nil{
            dictionary["fileUrl"] = fileUrl
        }
        if lastModified != nil{
            dictionary["lastModified"] = lastModified
        }
        if thumbnailFileName != nil{
            dictionary["thumbnailFileName"] = thumbnailFileName
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        return dictionary
    }
}
