//
//  RepairOrderEditSonOrderViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/8.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import RxCocoa


class RepairOrderEditSonOrderViewController: BaseTableViewController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 默认section高度
    let sectionHeight: CGFloat! = 30
    /// 维修前图片附件高度
    var beforAttachmentHeight: CGFloat! = 0
    /// 维修后图片附件高度
    var afterAttachmentHeight: CGFloat! = 0
    /// 工单数据
    open var billModel: BillDetailExecute!
    /// 主管指引、备件、工具
    @IBOutlet weak var toolOptionLabel: UILabel!
    /// 安全、防护、围封、环保
    @IBOutlet weak var protectOptionLabel: UILabel!
    /// 出工人
    @IBOutlet weak var workPersonLabel: UILabel!
    /// 到位时间
    @IBOutlet weak var placeTimeLabel: UILabel!
    /// 离开时间
    @IBOutlet weak var leaveTimeLabel: UILabel!
    /// 故障原因
    @IBOutlet weak var failureCauseLabel: UILabel!
    /// 处理方式
    @IBOutlet weak var processModeLabel: UILabel!
    /// 人工费
    @IBOutlet weak var costLaborText: UITextField!
    /// 物料费用
    @IBOutlet weak var materialCostLabel: UILabel!
    /// 描述
    @IBOutlet weak var describeTextView: IQTextView!
    /// 维修前图片附件
    lazy final var beforAttachmentVc: PhotoAttachmentViewController = {
        var attachmentVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        attachmentVc.delegate = self
        return attachmentVc
    }()
    
    /// 维修后图片附件
    lazy final var afterAttachmentVc: PhotoAttachmentViewController = {
        var attachmentVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        attachmentVc.delegate = self
        return attachmentVc
    }()
    
    /// 子工单详情ViewModel
    lazy final var childBillViewModel: ReparirChildBillViewModel = {
        var childBillViewModel = ReparirChildBillViewModel()
        return childBillViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        setupTableView()
        setupPhotoAttachmentVc()
        getBillDetailAction()
        bindingRxAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        describeTextView.placeholder = "描述"
        title = String(format: "完成%@工单", billModel.dept.name)
        describeTextView.textContainerInset = UIEdgeInsetsMake(0, 0, 0, 0)
        tableView.register(UINib(nibName: CostOrBorrowTableViewCell.name(), bundle: nil), forCellReuseIdentifier: CostOrBorrowTableViewCell.name())
    }
    
    // MARK: - 设置附件VC
    fileprivate func setupPhotoAttachmentVc(){
        addChildViewController(afterAttachmentVc)
        addChildViewController(beforAttachmentVc)
        beforAttachmentVc.attachmentViewModel.photoAttachments.append(PhotoAttachmentModel(add_Photo, .ATTACHMENT_ADD))
        afterAttachmentVc.attachmentViewModel.photoAttachments.append(PhotoAttachmentModel(add_Photo, .ATTACHMENT_ADD))
        afterAttachmentHeight = afterAttachmentVc.attachmentHeight(kONE,after)
        beforAttachmentHeight = beforAttachmentVc.attachmentHeight(kONE,befor)
    }
    
    // MARK: - 绑定RxSwift事件
    fileprivate func bindingRxAction() {
        costLaborText.rx.text.subscribe(onNext: {[weak self] (string) in
            self?.childBillViewModel.childBillDetailData.labourfee = string
        }).disposed(by: disposeBag)
        
        describeTextView.rx.text.subscribe(onNext: {[weak self] (string) in
            self?.childBillViewModel.childBillDetailData.note = string
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 获取子工单详情
    fileprivate func getBillDetailAction() {
        childBillViewModel.queryChildBillDetailAction(billModel.uuid).subscribe {[weak self] (event) in
            self?.childBillViewModel.childBillDetailAssignment(self!)
            self?.disposeAttachment()
            }.disposed(by: disposeBag)
    }
    
    // MARK: - 获取图片附件通过entity uuid
    fileprivate func disposeAttachment() {
        if !childBillViewModel.childBillDetailData.beginAttachmentId.isEmpty {
        childBillViewModel.downloadBeforAttachmentAction(childBillViewModel.childBillDetailData.beginAttachmentId)
            .subscribe(onNext: {[weak self] (result) in
                for model in result {
                    let url = String(format: attachmentUrl, model.entityType,model.entityUuid,model.fileName)
                    self?.beforAttachmentVc.attachmentViewModel.photoAttachments.insert(PhotoAttachmentModel(url, ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue, model.entityUuid, ATTACHMENT_LOCATION.ATTACHMENT_HTTP), at: kZERO)
                }
                self?.beforAttachmentHeight = self?.beforAttachmentVc.attachmentHeight(result.count + kONE,befor)
                self?.tableView.reloadData()
            }).disposed(by: disposeBag)
        }
        if !childBillViewModel.childBillDetailData.endAttachmentId.isEmpty {
            childBillViewModel.downloadAafterAttachmentAction(childBillViewModel.childBillDetailData.endAttachmentId)
                .subscribe(onNext: {[weak self] (result) in
                    for model in result {
                        let url = String(format: attachmentUrl, model.entityType,model.entityUuid,model.fileName)
                        self?.afterAttachmentVc.attachmentViewModel.photoAttachments.insert(PhotoAttachmentModel(url, ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue, model.entityUuid, ATTACHMENT_LOCATION.ATTACHMENT_HTTP), at: kZERO)
                    }
                    self?.afterAttachmentHeight = self?.afterAttachmentVc.attachmentHeight(result.count + kONE,after)
                    self?.tableView.reloadData()
            }).disposed(by: disposeBag)
        }
    }
    
    // MARK: - TableView
    fileprivate func setupTableView() {
        tableView.register(RepairAfterAttachmentTableViewCell.classForCoder(), forCellReuseIdentifier: RepairAfterAttachmentTableViewCell.name())
        tableView.register(RepairBeforAttachmentTableViewCell.classForCoder(), forCellReuseIdentifier: RepairBeforAttachmentTableViewCell.name())
        let completeView = RepairOrderEditSonOrderCompleteView.instantiateFromNib() as! RepairOrderEditSonOrderCompleteView
        //完成子工单
        completeView.completeBtn.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            if !PermissionsManager.finishChildPermissions() {
                ShowMessage("当前用户对此工单没有完成权限!")
                return;
            }
            ShowAlertView(hint, "确定完成此子工单吗？", [cancel,sure], .alert, { (index) in
                if index == kZERO { return }
                self?.uploadActtachmentAction().subscribe(onNext: { (result) in
                    self?.childBillViewModel.finishChildBillAction().subscribe(onNext: { () in
                        DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + 1.0, execute: {
                            NotificationCenter.default.post(Notification(name: Notification.Name(rawValue: UPDATE_BILL_DETAIL_LIST)))
                        })
                        ShowMessage("子工单完成")
                        self?.backUP()
                    }).disposed(by: self!.disposeBag)
                }).disposed(by: self!.disposeBag)
            })
        }).disposed(by: disposeBag)
        if PermissionsManager.finishChildPermissions() {
            tableView.tableFooterView = completeView
        }
        if PermissionsManager.saveChildPermissions() {
            navigationItem.rightBarButtonItem = createButtonItem("保存", nil, self, #selector(RepairOrderEditSonOrderViewController.saveButtonClickAction))
        }
    }
    func backUP(){
        Network.request(target: Service.ChildOrderComplete(self.childBillViewModel.childBillDetailData.uuid, "done"), success: { (json) in
            
        }, failure: { (error) in
            
        })
        DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + 0.2, execute: {
            self.popVC()
        })
    }
    // MARK: - 提交、保存子工单
    @objc fileprivate func saveButtonClickAction() {
        if !PermissionsManager.saveChildPermissions() {
            ShowMessage("当前用户对此工单没有保存权限!")
            return;
        }
        ShowAlertView(hint, "确定保存此子工单吗？", [cancel,sure], .alert) {[weak self] (index) in
            if index == kZERO { return }
            self?.uploadActtachmentAction().subscribe(onNext: { (result) in
                self?.childBillViewModel.saveChildBillAction().subscribe(onNext: { () in
                    self?.popVC()
                    ShowMessage("保存成功")
                }).disposed(by: self!.disposeBag)
            }).disposed(by: self!.disposeBag)
        }
    }
    
    // MARK: - 上传附件
    fileprivate func uploadActtachmentAction() ->Observable<(Void,Void)> {
        var beforFileUrlArray = Array<UploadPhotoAttachmentModel>()
        let beforEntityUuid = childBillViewModel.childBillDetailData.beginAttachmentId!
        for i in 0..<beforAttachmentVc.attachmentViewModel.photoAttachments.count - kONE {
            let image = beforAttachmentVc.attachmentViewModel.photoAttachments[i]
            if image.attachmentType == ATTACHMENT_LOCATION.ATTACHMENT_LOCAL {
                let imageName = randomMD5()
                let fileUrl = saveImage(currentImage: image.attachment as! UIImage, persent: 0.8, imageName: imageName + ".jpg")
                let model = UploadPhotoAttachmentModel(imageName, fileUrl, ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue, beforEntityUuid)
                beforFileUrlArray.append(model)
            }
        }
        var afterFileUrlArray = Array<UploadPhotoAttachmentModel>()
        let afterEntityUuid = childBillViewModel.childBillDetailData.endAttachmentId!
        for i in 0..<afterAttachmentVc.attachmentViewModel.photoAttachments.count - kONE {
            let image = afterAttachmentVc.attachmentViewModel.photoAttachments[i]
            if image.attachmentType == ATTACHMENT_LOCATION.ATTACHMENT_LOCAL {
                let imageName = randomMD5()
                let fileUrl = saveImage(currentImage: image.attachment as! UIImage, persent: 0.8, imageName: imageName + ".jpg")
                let model = UploadPhotoAttachmentModel(imageName, fileUrl, ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue, afterEntityUuid)
                afterFileUrlArray.append(model)
            }
        }
        return childBillViewModel.childBillUploadAttachmentAction(beforFileUrlArray, afterFileUrlArray)
    }
    
    // MARK: - 跳转子工单详情
    fileprivate func gotoChildBillDetailVc() {
        self.performSegue(withIdentifier: RepairOrderChildBillDetailViewController.name(), sender: nil)
    }
    
    // MARK: - UITableViewDelegate,UITableViewDataSource
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.section == CHILD_BILL_EDIT_SECTION.BEFORATTACHMENT.rawValue {
            let beforCell = tableView.dequeueReusableCell(withIdentifier: RepairBeforAttachmentTableViewCell.name(), for: indexPath)
            beforAttachmentVc.view.frame = CGRect(x: 15, y: 8, width: kWidth - 30, height: beforAttachmentHeight)
            beforCell.contentView.addSubview(beforAttachmentVc.view)
            beforAttachmentVc.photoAttachmentCollectionView.reloadData()
            return beforCell
        }
        if indexPath.section == CHILD_BILL_EDIT_SECTION.AFTERATTACHMENT.rawValue {
            let afterCell = tableView.dequeueReusableCell(withIdentifier: RepairAfterAttachmentTableViewCell.name(), for: indexPath)
            afterAttachmentVc.view.frame = CGRect(x: 15, y: 8, width: kWidth - 30, height: afterAttachmentHeight)
            afterCell.contentView.addSubview(afterAttachmentVc.view)
            afterAttachmentVc.photoAttachmentCollectionView.reloadData()
            return afterCell
        }
        if indexPath.section == CHILD_BILL_EDIT_SECTION.COST.rawValue {
            if indexPath.row != kZERO {
                let costCell = tableView.dequeueReusableCell(withIdentifier: CostOrBorrowTableViewCell.name(), for: indexPath) as! CostOrBorrowTableViewCell
                let model = childBillViewModel.childBillDetailData.executeOutsources[indexPath.row - kONE]
                costCell.updateCell(model, indexPath)
                return costCell
            }
        }
        if indexPath.section == CHILD_BILL_EDIT_SECTION.BORROW.rawValue {
            if indexPath.row != kZERO {
                let brrowCell = tableView.dequeueReusableCell(withIdentifier: CostOrBorrowTableViewCell.name(), for: indexPath) as! CostOrBorrowTableViewCell
                
                let model = childBillViewModel.childBillDetailData.executeMateriels[indexPath.row - kONE]
                brrowCell.updateCell(model, indexPath)
                return brrowCell
            }
        }
        return super.tableView(tableView, cellForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return kSectionZero
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == CHILD_BILL_EDIT_SECTION.DESCRIBE.rawValue {
            return 10
        }
        return sectionHeight
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        switch section {
        case CHILD_BILL_EDIT_SECTION.COST.rawValue:
            if childBillViewModel.childBillDetailData.executeOutsources == nil {
                return kONE
            }
            return childBillViewModel.childBillDetailData.executeOutsources.count + kONE
        case CHILD_BILL_EDIT_SECTION.BORROW.rawValue:
            if childBillViewModel.childBillDetailData.executeMateriels == nil {
                return kONE
            }
            return childBillViewModel.childBillDetailData.executeMateriels.count + kONE
        default:
            break
        }
        return super.tableView(tableView, numberOfRowsInSection: section)
    }
    
    //cell的缩进级别，动态静态cell必须重写，否则会造成崩溃
    override func tableView(_ tableView: UITableView, indentationLevelForRowAt indexPath: IndexPath) -> Int {
        switch indexPath.section {
        case CHILD_BILL_EDIT_SECTION.COST.rawValue:
            return super.tableView(tableView, indentationLevelForRowAt: IndexPath(row: 0, section: CHILD_BILL_EDIT_SECTION.COST.rawValue))
        case CHILD_BILL_EDIT_SECTION.BORROW.rawValue:
            return super.tableView(tableView, indentationLevelForRowAt: IndexPath(row: 0, section: CHILD_BILL_EDIT_SECTION.BORROW.rawValue))
        default:
            break
        }
        return super.tableView(tableView, indentationLevelForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.section == CHILD_BILL_EDIT_SECTION.BEFORATTACHMENT.rawValue {
            return beforAttachmentHeight + 20
        }
        if indexPath.section == CHILD_BILL_EDIT_SECTION.AFTERATTACHMENT.rawValue {
            return afterAttachmentHeight + 20
        }
        if indexPath.section == CHILD_BILL_EDIT_SECTION.COST.rawValue || indexPath.section == CHILD_BILL_EDIT_SECTION.BORROW.rawValue {
            if indexPath.row == kZERO {
                return 30
            }
            return kCellHeight
        }
        return super.tableView(tableView, heightForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        switch indexPath.section {
        case CHILD_BILL_EDIT_SECTION.COST.rawValue:
            if indexPath.row == kZERO {
                return
            }
            let costVc = ChildBillDetailCostViewController.instantiateViewController(.Function) as! ChildBillDetailCostViewController
            costVc.costModel = childBillViewModel.childBillDetailData.executeOutsources[indexPath.row - kONE]
            pushVC(costVc)
            break
        case CHILD_BILL_EDIT_SECTION.BORROW.rawValue:
            if indexPath.row == kZERO {
                return
            }
            let borrowVc = ChildBillDetailBorrowViewController.instantiateViewController(.Function) as! ChildBillDetailBorrowViewController
            borrowVc.borrowModel = childBillViewModel.childBillDetailData.executeMateriels[indexPath.row - kONE]
            pushVC(borrowVc)
            break
        default:
            break
        }
        childBillViewModel.didSelectRowAtIndexPath(indexPath, self)
    }
}

extension RepairOrderEditSonOrderViewController: PhotoAttachmentDelegate {
    func updatePhotoAttachment(_ height: CGFloat, _ key: String?) {
        switch key! {
        case befor:
            beforAttachmentHeight = height
            break
        case after:
            afterAttachmentHeight = height
            break
        default:
            break
        }
        tableView.reloadData()
    }
}
