//
//  RepairOrderDetailBgController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/12.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import SnapKit
import SwiftyJSON
import RxSwift

class RepairOrderDetailBgController: BaseViewController {

    /// 工单数据
    open var billModel: RepairOrderRecord!
    /// 转交、完成背景
    @IBOutlet weak var bottomBgView: UIView!
    @IBOutlet weak var bottomLayoutHeight: NSLayoutConstraint!
    /// 详情内容背景
    @IBOutlet weak var contentBgView: UIView!
    /// 转交
    @IBOutlet weak var transferButton: UIButton!
    /// 完成
    @IBOutlet weak var completeButton: UIButton!
    /// 工单详情控制器
    lazy final var detailVc: RepairOrderDetailViewController = {
        var detailVc = RepairOrderDetailViewController.instantiateViewController(.Function) as! RepairOrderDetailViewController
        return detailVc
    }()
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 悬浮View
    var suspendView: RepairOrderDetailSuspendView?
    /// 工单详情ViewModel
    lazy final var orderDetailViewModel: RepairOrderDetailViewModel = {
        var orderDetailViewModel = RepairOrderDetailViewModel()
        return orderDetailViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        uiConfigAction()
        addChildBillDetailVc()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        bottomBgView.addShadow(UIColor.black)
        if !PermissionsManager.transferBillPermissions() {
            transferButton.isHidden = true
        }
        if !PermissionsManager.finishBillPermissions() {
            completeButton.isHidden = true
        }
        if !PermissionsManager.finishBillPermissions() && !PermissionsManager.transferBillPermissions() {
            bottomLayoutHeight.constant = 0
            UIView.animate(withDuration: kAnimationTime, animations: {
                self.view.layoutIfNeeded()
            })
        }
    }

    // MARK: - 添加工单详情控制器
    fileprivate func addChildBillDetailVc() {
        detailVc.billModel = billModel
        contentBgView.addSubview(detailVc.view)
        detailVc.view.snp.makeConstraints { (make) in
            make.edges.equalTo(self.contentBgView)
        }
        addChildViewController(detailVc)
        detailVc.setStateBlock {[weak self] (state) in
            self?.rapairBillBottomViewAction(state)
        }
        detailVc.setSuspendViewAlphaBlock {[weak self] (alpha) in
            self?.suspendView?.alpha = alpha
        }
        detailVc.setSuspendViewStateBlock {[weak self] (model, indexPath,state) in
            if state == SUBMIT_REPAIR_ORDER_STATE.INIT.rawValue || state == SUBMIT_REPAIR_ORDER_STATE.DREW.rawValue {
                self?.setupSuspendViewAction(model,indexPath)
            }else {
                UIView.animate(withDuration: kAnimationTime, animations: {
                    self?.suspendView?.sety(y: kHeight)
                }, completion: { (bool) in
                    self?.suspendView?.removeFromSuperview()
                })
            }
        }
    }
    
    // MARK: - 转交工单
    @IBAction func transferButtonClickAction(_ sender: UIButton) {
        if !PermissionsManager.transferBillPermissions() {
            ShowMessage("当前用户对此工单没有转交权限!");
            return;
        }
        detailVc.transferRepairOrder()
    }
    
    // MARK: - 完成工单
    @IBAction func finishButtonClickAction(_ sender: UIButton) {
        if !PermissionsManager.finishBillPermissions() {
            ShowMessage("当前用户对此工单没有完成权限!")
            return;
        }
        // 判断子工单是否是终止状态
        for  executeModel in detailVc.orderDetailViewModel.billDetailModel.executes {
            if executeModel.state != SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue && executeModel.state != SUBMIT_REPAIR_ORDER_STATE.DONE.rawValue {
                ShowMessage("还有部门工单未完成")
                return
            }
        }
        let completeVc = RepairOrderCompletedViewController.instantiateViewController(.Function) as! RepairOrderCompletedViewController
        completeVc.setStateBlock({[weak self] (state) in
            self?.rapairBillBottomViewAction(state)
            Network.request(target: Service.CompleteMessageRemind(self?.detailVc.orderDetailViewModel.billDetailModel.uuid ?? "", "finished"), success: { (json) in
                
            }, failure: { (error) in
                
            })
        })
        completeVc.billCompleteViewModel.billCompltedModel = BillCompletedRequestModel(fromJson: JSON(detailVc.orderDetailViewModel.billDetailModel.toDictionary()))
        pushVC(completeVc)
    }
    
    // MARK: - 工单底部view
    fileprivate func rapairBillBottomViewAction(_ state: String) {
        
        if state == SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue || state == SUBMIT_REPAIR_ORDER_STATE.DELETED.rawValue || state == SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue || state == SUBMIT_REPAIR_ORDER_STATE.CREATED.rawValue  {
            bottomLayoutHeight.constant = 0
            UIView.animate(withDuration: kAnimationTime, animations: {
                self.view.layoutIfNeeded()
            })
        }else {
            bottomLayoutHeight.constant = 50
            UIView.animate(withDuration: kAnimationTime, animations: {
                self.view.layoutIfNeeded()
            })
        }
        
        if state == SUBMIT_REPAIR_ORDER_STATE.CREATED.rawValue {
            setupSendButtonItem()
        }
    }
    
    // MARK: - 设置发出按钮
    fileprivate func setupSendButtonItem() {
        navigationItem.rightBarButtonItem = UIBarButtonItem(title: "发出", style: .done, target: self, action: #selector(RepairOrderDetailBgController.sendBtnAction))
    }
    
    // MARK: - 发出工单
    @objc func sendBtnAction() {
        orderDetailViewModel.usefulWorkBillAction(billModel.uuid).subscribe(onNext: {[weak self] () in
            NotificationCenter.default.post(Notification(name: Notification.Name(rawValue: UPDATE_BILL_LIST)))
            self?.popVC()
            ShowMessage("工单已发出")
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 设置悬浮框
    fileprivate func setupSuspendViewAction(_ model: BillDetailExecute, _ indexPath: IndexPath) {
        self.suspendView?.removeFromSuperview()
        let suspendView = RepairOrderDetailSuspendView.instantiateFromNib() as! RepairOrderDetailSuspendView
        suspendView.updateSuspendView(model, indexPath)
        suspendView.frame = CGRect(x: 15, y: kHeight, width: kWidth - 30, height: 60)
        self.suspendView = suspendView
        self.view.addSubview(suspendView)
        self.view.bringSubview(toFront: suspendView)
        UIView.animate(withDuration: kAnimationTime, animations: {
            suspendView.sety(y: self.view.height - kNavHeight - kTabBarHeight)
        })
        suspendView.operationOrderBtn.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.detailVc.suspendViewButtonClickAction(suspendView.operationOrderBtn.currentTitle!,model,indexPath)
        }).disposed(by: disposeBag)
    }
}



