//
//  EditImageViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/2/1.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

public typealias SaveImageBlock = (String) ->Void

class EditImageViewController: BaseViewController {

    var type: LOCATION_IMAGE_TYPE!
    
    /// 图片路径,查看时为本地路径，编辑时为网络路径
    open var imageString: String?
    open var imageArray: [FloorLayerData]!
    
    var attachmentImg: BaseEditImageView!
    
    /// 回调
    var saveImageBlock: SaveImageBlock?
    
    /// 楼层区分TableView
    final lazy var selectedTableView: UITableView = {
       var selectedTableView = UITableView(frame: CGRect(x: 20, y: 30, width: 60, height: 150), style: .plain)
        selectedTableView.delegate = self
        selectedTableView.showsVerticalScrollIndicator = false
        selectedTableView.dataSource = self
        return selectedTableView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        self.fd_interactivePopDisabled = true;
        view.backgroundColor = kGaryColor
        attachmentImg = BaseEditImageView(frame: view.bounds)
        view.addSubview(attachmentImg)
        view.clipsToBounds = true
        if type == .EDIT {
            title = "编辑位置图"
            navigationItem.rightBarButtonItem = createButtonItem("保存", nil, self, #selector(EditImageViewController.saveButtonClickAction))
            let locationImg = BaseEditImageView(frame: CGRect(x: 0, y: 0, width: 40, height: 40))
            locationImg.image = UIImage(named: "location_red")
            locationImg.center = attachmentImg.center
            attachmentImg.addSubview(locationImg)
            let attachment = imageArray.first!.attachments.first
            if attachment == nil {
                ShowMessage("无楼层图片数据")
                return
            }
            let imageString =  String(format: attachmentUrl, attachment!.entityType,attachment!.entityUuid,attachment!.fileName)
            attachmentImg.kf.setImage(with: URL(string: imageString), placeholder: loadingImage)
            selectedTableView.register(UITableViewCell.classForCoder(), forCellReuseIdentifier: UITableViewCell.name())
            view.addSubview(selectedTableView)
            selectedTableView.selectRow(at: IndexPath(row: 0, section: 0), animated: true, scrollPosition: .top)
        }else {
            title = "查看位置图"
            if let imageString = imageString {
                attachmentImg.image = UIImage(contentsOfFile: imageString)
            }
        }
    }
    
    // MARK: - 保存
    @objc func saveButtonClickAction() {
        guard saveImageBlock != nil else {
            ShowMessage("请先实现回调方法")
            return
        }
        popVC()
        let string = saveImage(currentImage: capture(attachmentImg), persent: 1, imageName: "editAttachmentImage")
        saveImageBlock!(string)
    }
    
    // MARK: - 保存图片附件至沙盒
    open func saveImage(currentImage: UIImage, persent: CGFloat, imageName: String) ->String {
        if let imageData = UIImageJPEGRepresentation(currentImage, persent) as NSData? {
            let fullPath = NSHomeDirectory().appending("/Documents/Files").appending(imageName)
            imageData.write(toFile: fullPath, atomically: true)
            return fullPath
        }
        return ""
    }
    
    // MARK: - 保存图片后回调
    func setSaveImageBlock(_ block: @escaping SaveImageBlock) {
        self.saveImageBlock = block
    }
    
    // MARK: - 截图
    func capture(_ view: UIImageView) ->UIImage {
        UIGraphicsBeginImageContextWithOptions(view.bounds.size, view.isOpaque, 0.0)
        view.layer.render(in: UIGraphicsGetCurrentContext()!)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return image!
    }
}

extension EditImageViewController: UITableViewDelegate,UITableViewDataSource  {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if imageString != nil {
            return kZERO
        }
        return imageArray.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let towerCell = tableView.dequeueReusableCell(withIdentifier: UITableViewCell.name(), for: indexPath)
        towerCell.textLabel?.textAlignment = .center
        towerCell.textLabel?.text = imageArray[indexPath.row].name!
        towerCell.textLabel?.font = UIFont.systemFont(ofSize: 12)
        return towerCell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let attachment = imageArray[indexPath.row].attachments.first!
        let imageString =  String(format: attachmentUrl, attachment.entityType,attachment.entityUuid,attachment.fileName)
        if type == .EDIT {
            attachmentImg.kf.setImage(with: URL(string: imageString), placeholder: loadingImage)
        }else {
            attachmentImg.image = UIImage(contentsOfFile: imageString)
        }
    }
}



























