//
//  ChildBillDetailCostViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/3/12.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class ChildBillDetailCostViewController: BaseTableViewController {

    /// 物料
    @IBOutlet weak var logisticsLabel: UILabel!
    /// 单价
    @IBOutlet weak var priceLabel: UILabel!
    /// 数量
    @IBOutlet weak var countLabel: UILabel!
    /// 合计
    @IBOutlet weak var totalPriceLabel: UILabel!
    /// 提取数量
    @IBOutlet weak var extractCountLabel: UILabel!
    /// 退料数量
    @IBOutlet weak var returnCountLabel: UILabel!
    
    open var costModel: ExecuteMateriel!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        setupDataAction()
    }
    
    // MARK: - 设置数据源
    fileprivate func setupDataAction() {
        let useQty = costModel.getQty - costModel.backQty
        logisticsLabel.text = costModel.materiel.name
        priceLabel.text = String(format: "%.2f", costModel.unitPrice)
        countLabel.text = String(format: "%.2f", useQty)
        totalPriceLabel.text = String(format: "%.2f", costModel.unitPrice * useQty)
        extractCountLabel.text = String(format: "%.2f", costModel.getQty)
        returnCountLabel.text = String(format: "%.2f", costModel.backQty)
    }

    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return kSectionTen
    }
}







