//
//  FunctionViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class FunctionViewController: BaseViewController {

    /// 功能列表
    @IBOutlet weak var functionCollectionView: UICollectionView!
    @IBOutlet weak var functionFlowLayout: UICollectionViewFlowLayout!
    
    /// FunctionViewModel
    lazy final var functionViewModel: FunctionViewModel = {
       var functionViewModel = FunctionViewModel()
        return functionViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupCollectionView()
    }

    // MARK: - 设置UICollectionView
    fileprivate func setupCollectionView() {
        functionFlowLayout.itemSize = CGSize(width: kWidth / 4.0, height: kWidth / 4.0 - 20)
        functionFlowLayout.minimumLineSpacing = 0
        functionFlowLayout.minimumInteritemSpacing = 0
        functionCollectionView.alwaysBounceVertical = true
    }
}

extension FunctionViewController: UICollectionViewDelegate,UICollectionViewDataSource {
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        return functionViewModel.dequeueReusableCell(FunctionCollectionViewCell.name(), collectionView, indexPath)
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return functionViewModel.itemArrays.count
    }
    
    func collectionView(_ collectionView: UICollectionView, viewForSupplementaryElementOfKind kind: String, at indexPath: IndexPath) -> UICollectionReusableView {
        let sectionView = collectionView.dequeueReusableSupplementaryView(ofKind: UICollectionElementKindSectionHeader, withReuseIdentifier: FunctionCollectionReusableView.name(), for: indexPath)
        return sectionView
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        let model = functionViewModel.itemArrays[indexPath.item]
        switch model.item_name {
        case FunctionType.TODO.rawValue:
            if !PermissionsManager.todoViewPermissions() {
                ShowMessage("当前用户对待办事项没有查看权限!")
                return
            }
            self.performSegue(withIdentifier: TodoViewController.name(), sender: nil)
            break
        case FunctionType.REPAIRORDER.rawValue:
            if !PermissionsManager.billViewPermissions() {
                ShowMessage("当前用户对工单没有查看权限!")
                return
            }
            self.performSegue(withIdentifier: RepairOrderViewController.name(), sender: nil)
            break
        default:
            break
        }
    }
}




















