//
//  AccountViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/9.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import RxCocoa

class AccountViewModel: BaseViewModel {


}

extension AccountViewModel {
    
    // MARK: - 退出登录
    func loginOutAction() {
        ShowAlertView("提示", "请确认是否退出登录?", ["取消","确认"], .alert) { (index) in
            if index == kZERO { return }
            do {
                try FileManager.default.removeItem(atPath: accountPath)
            }catch {
                ShowMessage("删除用户信息失败")
            }
            AppManager.shareInstance.openLoginVc()
        }
    }
    
    // MARK: - 修改密码
    func changePasswordAction(_ newPassword: String) ->Observable<Void> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .ChangePassword(newPassword), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    kUser().password = newPassword
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
}

















