//
//  ChangePasswordTableViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/9.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift


class ChangePasswordTableViewController: BaseTableViewController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 旧密码
    @IBOutlet weak var oldPasswordText: UITextField!
    /// 新密码
    @IBOutlet weak var newPasswordText: UITextField!
    /// 确认新密码
    @IBOutlet weak var new2PasswordText: UITextField!
    /// 确认新密码
    @IBOutlet weak var affirmButton: UIButton!
    /// 账户VieWModel
    lazy final var accountViewModel: AccountViewModel = {
        var accountViewModel = AccountViewModel()
        return accountViewModel;
    }()
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        bindingRxAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        affirmButton.addAngle(5.0)
    }
    
    // MARK: - UITextField绑定RxSwift事件
    fileprivate func bindingRxAction() {
        let oldPasswordValid = oldPasswordText.rx.text.map { (text) -> Bool in
                if (text?.isEmpty)! {
                    return false
                }
                return true
            }
        let newPasswordValid = newPasswordText.rx.text.map { (text) -> Bool in
                if (text?.isEmpty)! {
                    return false
                }
                return true
            }
        let new2PasswordValid = new2PasswordText.rx.text.map { (text) -> Bool in
                if (text?.isEmpty)! {
                    return false
                }
                return true
            }
    
        Observable.combineLatest(oldPasswordValid,newPasswordValid,new2PasswordValid).map { (oldPasswordValid,newPasswordValid,new2PasswordValid) -> Bool in
            return oldPasswordValid && newPasswordValid && new2PasswordValid
            }.subscribe(onNext: {[weak self] (bool) in
                self?.affirmButton.isEnabled = bool
                self?.affirmButton.alpha = bool ? 1 : 0.5
            }).disposed(by: disposeBag)
    }
    
    // MARK: - 确认新密码
    @IBAction func affirmButtonClickAction(_ sender: UIButton) {
        if new2PasswordText.text != newPasswordText.text {
            ShowMessage("请确认两次密码是否相同")
            return
        }
        accountViewModel.changePasswordAction(new2PasswordText.text!).subscribe(onNext: {[weak self] () in
            ShowMessage("密码修改成功")
            self?.popVC()
        }).disposed(by: disposeBag)
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return kSectionZero
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return kSectionTen
    }
    
}



















