//
//	TenantResultModel.swift
//
//	Create by 云霄 曹 on 12/3/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON


class TenantResultModel : NSObject{

	var data : TenantData!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = TenantData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			dictionary["data"] = data.toDictionary()
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}

class TenantData : NSObject{
    
    var paging : TenantPaging!
    var records : [TenantRecord]!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        let pagingJson = json["paging"]
        if !pagingJson.isEmpty{
            paging = TenantPaging(fromJson: pagingJson)
        }
        records = [TenantRecord]()
        let recordsArray = json["records"].arrayValue
        for recordsJson in recordsArray{
            let value = TenantRecord(fromJson: recordsJson)
            records.append(value)
        }
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if paging != nil{
            dictionary["paging"] = paging.toDictionary()
        }
        if records != nil{
            var dictionaryElements = [[String:Any]]()
            for recordsElement in records {
                dictionaryElements.append(recordsElement.toDictionary())
            }
            dictionary["records"] = dictionaryElements
        }
        return dictionary
    }
}

class TenantRecord : NSObject{
    
    var code : String!
    var contractCode : String!
    var contractId : String!
    var contractName : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var enabled : Bool!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var name : String!
    var shopSigns : String!
    var store : UCN!
    var uuid : String!
    var version : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        code = json["code"].stringValue
        contractCode = json["contractCode"].stringValue
        contractId = json["contractId"].stringValue
        contractName = json["contractName"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        enabled = json["enabled"].boolValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        name = json["name"].stringValue
        shopSigns = json["shopSigns"].stringValue
        let storeJson = json["store"]
        if !storeJson.isEmpty{
            store = UCN(fromJson: storeJson)
        }
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if code != nil{
            dictionary["code"] = code
        }
        if contractCode != nil{
            dictionary["contractCode"] = contractCode
        }
        if contractId != nil{
            dictionary["contractId"] = contractId
        }
        if contractName != nil{
            dictionary["contractName"] = contractName
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if enabled != nil{
            dictionary["enabled"] = enabled
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if name != nil{
            dictionary["name"] = name
        }
        if shopSigns != nil{
            dictionary["shopSigns"] = shopSigns
        }
        if store != nil{
            dictionary["store"] = store.toDictionary()
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        return dictionary
    }
    
}

class TenantPaging : NSObject{
    
    var page : Int!
    var pageCount : Int!
    var pageSize : Int!
    var recordCount : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        page = json["page"].intValue
        pageCount = json["pageCount"].intValue
        pageSize = json["pageSize"].intValue
        recordCount = json["recordCount"].intValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if page != nil{
            dictionary["page"] = page
        }
        if pageCount != nil{
            dictionary["pageCount"] = pageCount
        }
        if pageSize != nil{
            dictionary["pageSize"] = pageSize
        }
        if recordCount != nil{
            dictionary["recordCount"] = recordCount
        }
        return dictionary
    }
    
}
