//
//	InitiatorResultModel.swift
//
//	Create by 云霄 曹 on 12/3/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON


class InitiatorResultModel : NSObject{

	var data : [InitiatorResultData]!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [InitiatorResultData]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			let value = InitiatorResultData(fromJson: dataJson)
			data.append(value)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			var dictionaryElements = [[String:Any]]()
			for dataElement in data {
				dictionaryElements.append(dataElement.toDictionary())
			}
			dictionary["data"] = dictionaryElements
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}

}

class InitiatorResultData : NSObject{
    
    var address : String!
    var belongOrg : String!
    var businessType : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var email : String!
    var enabled : Bool!
    var enterprise : String!
    var jobGrade : String!
    var jobLeavel : String!
    var jobPost : String!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var login : String!
    var mobile : String!
    var name : String!
    var password : String!
    var position : String!
    var positions : [String]!
    var remark : String!
    var state : String!
    var thirdLogin : String!
    var uuid : String!
    var version : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        address = json["address"].stringValue
        belongOrg = json["belongOrg"].stringValue
        businessType = json["businessType"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        email = json["email"].stringValue
        enabled = json["enabled"].boolValue
        enterprise = json["enterprise"].stringValue
        jobGrade = json["jobGrade"].stringValue
        jobLeavel = json["jobLeavel"].stringValue
        jobPost = json["jobPost"].stringValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        login = json["login"].stringValue
        mobile = json["mobile"].stringValue
        name = json["name"].stringValue
        password = json["password"].stringValue
        position = json["position"].stringValue
        positions = [String]()
        let positionsArray = json["positions"].arrayValue
        for positionsJson in positionsArray{
            positions.append(positionsJson.stringValue)
        }
        remark = json["remark"].stringValue
        state = json["state"].stringValue
        thirdLogin = json["thirdLogin"].stringValue
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if address != nil{
            dictionary["address"] = address
        }
        if belongOrg != nil{
            dictionary["belongOrg"] = belongOrg
        }
        if businessType != nil{
            dictionary["businessType"] = businessType
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if email != nil{
            dictionary["email"] = email
        }
        if enabled != nil{
            dictionary["enabled"] = enabled
        }
        if enterprise != nil{
            dictionary["enterprise"] = enterprise
        }
        if jobGrade != nil{
            dictionary["jobGrade"] = jobGrade
        }
        if jobLeavel != nil{
            dictionary["jobLeavel"] = jobLeavel
        }
        if jobPost != nil{
            dictionary["jobPost"] = jobPost
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if login != nil{
            dictionary["login"] = login
        }
        if mobile != nil{
            dictionary["mobile"] = mobile
        }
        if name != nil{
            dictionary["name"] = name
        }
        if password != nil{
            dictionary["password"] = password
        }
        if position != nil{
            dictionary["position"] = position
        }
        if positions != nil{
            dictionary["positions"] = positions
        }
        if remark != nil{
            dictionary["remark"] = remark
        }
        if state != nil{
            dictionary["state"] = state
        }
        if thirdLogin != nil{
            dictionary["thirdLogin"] = thirdLogin
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        return dictionary
    }
}
