//
//	InitiatorModel.swift
//
//	Create by 云霄 曹 on 11/1/2018
//	Copyright © 2018. All rights reserved.

//报事人
import Foundation 
import SwiftyJSON

class InitiatorModel{

    var data : InitiatorData!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
        let dataJson = json["data"]
        if !dataJson.isEmpty{
            data = InitiatorData(fromJson: dataJson)
        }
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

}

class InitiatorData {
    var paging : Paging!
    var records : [InitiatorRecord]!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        let pagingJson = json["paging"]
        if !pagingJson.isEmpty{
            paging = Paging(fromJson: pagingJson)
        }
        records = [InitiatorRecord]()
        let recordsArray = json["records"].arrayValue
        for recordsJson in recordsArray{
            let value = InitiatorRecord(fromJson: recordsJson)
            records.append(value)
        }
    }
}

class InitiatorRecord{
    
    var login : String!
    var name : String!
    var position : String!
    var uuid : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        login = json["login"].stringValue
        name = json["name"].stringValue
        position = json["position"].stringValue
        uuid = json["uuid"].stringValue
    }
    
}


