//
//	DeviceModel.swift
//
//	Create by 云霄 曹 on 11/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON

class DeviceModel {

	var data : DeviceData!
	var message : String!
	var success : Bool!

	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = DeviceData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}
}

class DeviceData{
    
    var paging : Paging!
    var records : [DeviceRecord]!

    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        let pagingJson = json["paging"]
        if !pagingJson.isEmpty{
            paging = Paging(fromJson: pagingJson)
        }
        records = [DeviceRecord]()
        let recordsArray = json["records"].arrayValue
        for recordsJson in recordsArray{
            let value = DeviceRecord(fromJson: recordsJson)
            records.append(value)
        }
    }
}

class DeviceRecord{
    
    var bussiness : String!
    var code : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var enabled : Bool!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var location : String!
    var name : String!
    var note : String!
    var store : UCN!
    var type : UCN!
    var uuid : String!
    var version : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        bussiness = json["bussiness"].stringValue
        code = json["code"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        enabled = json["enabled"].boolValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        location = json["location"].stringValue
        name = json["name"].stringValue
        note = json["note"].stringValue
        let storeJson = json["store"]
        if !storeJson.isEmpty{
            store = UCN(fromJson: storeJson)
        }
        let typeJson = json["type"]
        if !typeJson.isEmpty{
            type = UCN(fromJson: typeJson)
        }
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
    }
}




