//
//  PhotoAttachmentCollectionViewCell.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import Kingfisher

protocol DeleteAttachmentDelegate {
    func deleteAttachment(_ indexPath: IndexPath)
}

class PhotoAttachmentCollectionViewCell: UICollectionViewCell {
    
    /// 删除附件
    var delegate: DeleteAttachmentDelegate?
    /// 附件
    @IBOutlet weak var attachmentImg: UIImageView!
    /// 删除
    @IBOutlet weak var deleteBtn: UIButton!
    /// 附件位置信息
    var indexPath: IndexPath!
    
    // MARK: - 删除附件
    @IBAction func deleteButtonClickAction(_ sender: UIButton) {
        delegate?.deleteAttachment(indexPath)
    }
    
    // MARK: - 更新附件cell
    open func updateAttachmentCell(_ model: PhotoAttachmentModel<Any>,_ indexPath: IndexPath) {
        self.indexPath = indexPath
        switch model.attachmentType {
        case .ATTACHMENT_LOCAL:
            attachmentImg.image = model.attachment as? UIImage
            attachmentImg.contentMode = .scaleAspectFill
            deleteBtn.isHidden = false
            break
        case .ATTACHMENT_ADD:
            attachmentImg.image = UIImage(named: model.attachment as! String)
            attachmentImg.contentMode = .scaleToFill
            deleteBtn.isHidden = true
            break
        case .ATTACHMENT_HTTP:
            attachmentImg.kf.setImage(with: URL(string: model.attachment as! String), placeholder: loadingImage)
            attachmentImg.contentMode = .scaleAspectFill
            deleteBtn.isHidden = true
            break
        }
    }
}












