//
//  NetworkAPI.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/11/30.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation
import Moya
import Alamofire
import SwiftyJSON

public enum Service {
    // MARK: - 登录
    case Login(String,String)
    // MARK: - 待办事项查询
    case QueryTodo(QueryTodoModel)
    // MARK: - 新建工单查询来源
    case QuerySource()
    // MARK: - 新建工单服务类型
    case QueryServerType()
    // MARK: - 新建工单商户
    case QueryTenant(QueryModel)
    // MARK: - 新建工单优先级
    case QueryPrority()
    // MARK: - 查询报事人
    case QueryInitiator(QueryModel)
    // MARK: - 查询位置
    case QueryPosition(QueryModel)
    // MARK: - 查询设施
    case QueryDevice(DeviceQueryModel)
    // MARK: - 提交工单
    case SubmitOrder(SaveRepairOrderModel)
    // MARK: - 生效工单
    case UsefulWorkBill(String)
    // MARK: - 查询工单列表
    case QueryRepairOrder(RepairOrderQueryModel)
    // MARK: - 查询工单详情
    case GetRepairOrderDetail(String)
    // MARK: - 查询子单详情
    case GetChildBillDetail(String)
    // MARK: - 查询工单详情转交部门
    case GetRepairOrderDepartment(QueryModel)
    // MARK: - 工单详情转交
    case TransferOrder(DepartmentQueryModel)
    // MARK: - 工单详情完成
    case CompleteOrder(BillCompletedRequestModel)
    // MARK: - 主管指引/备件/工具
    case QueryToolOption()
    // MARK: - 安全/防护/围封/环保
    case QueryProtectOption()
    // MARK: - 查询楼宇
    case Queryflooryu(FlooryuQueryModel)
    // MARK: - 通过楼宇查询楼层
    case Queryfloorlayer(String)
    // MARK: - 查询登录人所属项目，可能为空
    case QueryStoreByUserId
    // MARK: - 查询登录人项目下属组织
    case QueryStoreSubOrgs(String)
    // MARK: - 故障原因
    case QuerybrokenOption()
    // MARK: - 处理方式
    case QueryprocessMethods()
    // MARK: - 项目
    case QueryProjectOption(ProjectQueryModel)
    // MARK: - 上传图片附件
    // 图片entityUuid  本地文件路径
    case UploadAttachment(UploadPhotoAttachmentModel)
    // MARK: - 下载图片附件
    // String 附件类型   String 附件id
    case DownloadAttachment(String,String)
    // MARK: - 子工单工单uuid
    case GetChildBill(String)
    // MARK: - 保存及更新子工单
    case SaveChildBill(ChildBillDetailData)
    // MARK: - 完成子工单
    case FinishChildBill(ChildBillDetailData)
    // MARK: - 检查版本更新
    case UpdateVersion()
    // MARK: - 修改密码
    case ChangePassword(String)
    // MARK: - 完成工单消息
    case CompleteMessageRemind(String,String)
    // MARK: - 子工单消息
    case ChildOrderComplete(String,String)
}

extension Service: TargetType {
    public var baseURL: URL {
        return URL(string: BaseUrl)!
    }
    
    public var path: String {
        switch self {
        case .Login(let name, _):
            return String(format: loginUrl, name)
        case .QueryTodo(_):
            return todoUrl
        case .QuerySource:
            return sourceUrl
        case .QueryServerType:
            return serviceTypeUrl
        case .QueryPrority:
            return prorityUrl
        case .QueryInitiator(let model):
            return String(format: initiatorUrl2, model.storeUuidEquals)
        case .QueryPosition(_):
            return positionUrl
        case .QueryProjectOption(_):
            return projectUrl
        case .QueryStoreByUserId:
            return String(format: storeByUser, kUser().userUuid)
        case .QueryStoreSubOrgs(let uuid):
            return String(format: storeSubOrgs, uuid)
        case .QueryDevice(_):
            return deviceUrl
        case .Queryflooryu:
            return flooryuUrl
        case .Queryfloorlayer(let uuid):
            return String(format: floorlayerUrl, uuid)
        case .SubmitOrder(_):
            let path = saveRepairOrderUrl + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .QueryRepairOrder(_):
            let path = repairOrderUrl + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .GetRepairOrderDetail(let billNumber):
            let path = String(format: getBillDetailUrl, billNumber) + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .GetRepairOrderDepartment:
            return organizationUrl
        case .TransferOrder(_):
            let path = batchTransferUrl + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .GetChildBill(let billUuid):
            let path = String(format: drawExecute, billUuid) + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .SaveChildBill(_):
            let path = saveExecute + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .FinishChildBill(_):
            let path = finishExecute + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .QueryToolOption:
            return toolOptionUrl
        case .QueryProtectOption:
            return protectOptionUrl
        case .QuerybrokenOption:
            return brokenOptionUrl
        case .QueryprocessMethods:
            return processMethodsUrl
        case .CompleteOrder:
            let path = completedBillUrl + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .UploadAttachment(let model):
            return String(format: uploadAttachmentUrl, model.entityType,model.entityUuid)
        case .DownloadAttachment(let entity_type, let entity_uuid):
            return String(format: downloadAttachmentUrl, entity_type,entity_uuid)
        case .GetChildBillDetail(let uuid):
            let path = String(format: getChildBillDetailUrl, uuid) + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .UpdateVersion():
            return updateUrl
        case .ChangePassword(_):
            let path = String(format: changePassword, kUser().userUuid,NSDate().httpParameterString(),kUser().userCode,kUser().userName)
            return path.urlEncoded()
        case .QueryTenant(_):
            return queryTenant
        case .UsefulWorkBill(let uuid):
            let path = String(format: usefulWorkBill, uuid) + "?operator.operId=\(kUser().userCode!)&operator.operName=\(kUser().userName!)&time=\(NSDate().httpParameterString()!)"
            return path.urlEncoded()
        case .CompleteMessageRemind(let uuid, let step):
            let path = String(format: submitMessageRemind, uuid,step)
            return path.urlEncoded()
        case .ChildOrderComplete(let uuid, let step):
            let path = String(format: drawMessageRemind, uuid,step)
            return path.urlEncoded()
        }
    }
    
    public var method: Moya.Method {
        switch self {
        case .Login(_, _),
             .QueryTodo(_),
             .QueryPosition(_),
             .QueryDevice(_),
             .SubmitOrder(_),
             .QueryRepairOrder(_),
             .GetRepairOrderDepartment(_),
             .TransferOrder(_),
             .CompleteOrder(_),
             .UploadAttachment(_),
             .SaveChildBill(_),
             .ChangePassword(_),
             .FinishChildBill(_),
             .QueryProjectOption(_),
             .UsefulWorkBill(_),
             .QueryTenant(_),
             .Queryflooryu(_):
            return .post
        case .QuerySource(),
             .QueryServerType(),
             .GetRepairOrderDetail(_),
             .QueryToolOption(),
             .QueryProtectOption(),
             .QuerybrokenOption(),
             .QueryprocessMethods(),
             .DownloadAttachment(_, _),
             .GetChildBill(_),
             .GetChildBillDetail(_),
             .UpdateVersion(),
             .Queryfloorlayer(_),
             .QueryStoreByUserId,
             .QueryStoreSubOrgs(_),
             .QueryInitiator(_),
             .QueryPrority(),
             .ChildOrderComplete(_, _),
             .CompleteMessageRemind(_,_):
            return .get
        }
    }
    
    public var sampleData: Data {
        return "Create post successfully".data(using: String.Encoding.utf8)!
    }
    
    public var task: Task {
        switch self {
        case .Login(_, let password):
            return .requestParameters(parameters: ["password": password,
                                                   "authenticode": "211534962"],
                                      encoding: JSONEncoding.default)
        case .ChangePassword(let password):
            let oldPassword = NSString(string: kUser().password)
            let newPassword = NSString(string: password)
            return .requestParameters(parameters: ["newPassword": newPassword.md5(),
                                                   "oldPassword": oldPassword.md5()],
                                      encoding: JSONEncoding.default)
        case .QueryTodo(let model):
            return .requestParameters(parameters: model.toDictionary(),
                                      encoding: JSONEncoding.default)
        case .QuerySource(),
             .QueryServerType(),
             .GetRepairOrderDetail(_),
             .QueryToolOption(),
             .QueryProtectOption(),
             .QuerybrokenOption(),
             .QueryprocessMethods(),
             .UsefulWorkBill(_),
             .GetChildBillDetail(_),
             .DownloadAttachment(_,_),
             .UpdateVersion(),
             .GetChildBill(_),
             .QueryStoreSubOrgs(_),
             .QueryStoreByUserId,
             .Queryfloorlayer(_),
             .QueryInitiator(_),
             .CompleteMessageRemind(_,_),
             .ChildOrderComplete(_, _),
             .QueryPrority():
            return .requestPlain
        case .GetRepairOrderDepartment(let model),
             .QueryTenant(let model),
             .QueryPosition(let model):
            return .requestParameters(parameters: model.toDictionary(),
                                      encoding: JSONEncoding.default)
        case .QueryDevice(let queryModel):
            return .requestParameters(parameters: queryModel.toDictionary(),
                                     encoding: JSONEncoding.default)
        case .SubmitOrder(let submitModel):
            return .requestParameters(parameters: submitModel.toDictionary(),
                                      encoding: JSONEncoding.default)
        case .QueryRepairOrder(let queryModel):
            return .requestParameters(parameters: queryModel.toDictionary(),
                                      encoding: JSONEncoding.default)
        case .TransferOrder(let queryModel):
            return .requestParameters(parameters: queryModel.toDictionary(),
                                      encoding: JSONEncoding.default)
        case .CompleteOrder(let queryModel):
            return .requestParameters(parameters: queryModel.toDictionary(),
                                      encoding: JSONEncoding.default)
        case .UploadAttachment(let attachmentModel):
            let data = MultipartFormData(provider: .file(URL(fileURLWithPath: attachmentModel.fileUrl)), name: "file", fileName: attachmentModel.fileName, mimeType: "image/jpeg")
            return .uploadMultipart([data])
        case .SaveChildBill(let model):
            return .requestParameters(parameters: model.toDictionary(), encoding: JSONEncoding.default)
        case .FinishChildBill(let model):
            return .requestParameters(parameters: model.toDictionary(), encoding: JSONEncoding.default)
        case .QueryProjectOption(let model):
            return .requestParameters(parameters: model.toDictionary(), encoding: JSONEncoding.default)
        case .Queryflooryu(let model):
            return .requestParameters(parameters: model.toDictionary(), encoding: JSONEncoding.default)
        }
    }
    
    public var headers: [String : String]? {
        return ["device" : UIDevice.current.name]
    }
}












