//
//  UIViewController+Extension.swift
//  CStoreEdu-iOS
//
//  Created by 曹云霄 on 2017/3/10.
//  Copyright © 2017年 上海勾芒信息科技有限公司. All rights reserved.
//

import Foundation
import SnapKit
import UIKit


public enum StoryboardType: String {
    case Main = "Main"
    case Home = "Home"
    case Function = "Function"
    case Me = "Me"
}


extension UIViewController {
    
    // MARK: -返回storyboard对象
    class func instantiateViewController(_ storyBoardName: StoryboardType) -> UIViewController {
        let storyBoard = UIStoryboard(name: storyBoardName.rawValue, bundle: nil)
        return storyBoard.instantiateViewController(withIdentifier: "\(self)")
    }
    
    // MARK: -返回控制器名称
    class func name() -> String {
        return "\(self)"
    }
}



extension UIViewController {
    
    
    // MARK: - 添加搜索框到导航栏
    open func addSearchBarToNav() ->UISearchBar {
        let searchBar = UISearchBar()
        searchBar.barStyle = .black
        searchBar.placeholder = "请输入关键字"
        navigationItem.titleView = searchBar
        return searchBar
    }
    
    // MARK: - 创建UIBarbuttonItem
    open func createButtonItem(_ title: String?, _ imageName: String?,_ target: Any,_  action: Selector) ->UIBarButtonItem {
        let button = UIButton(type: .custom)
        button.addTarget(target, action: action, for: .touchUpInside)
        button.titleLabel?.font = UIFont.boldSystemFont(ofSize: 15)
        if title != nil {
            button.setTitle(title, for: .normal)
        }else if imageName != nil  {
            button.setImage(UIImage(named: imageName!), for: .normal)
        }else {
            button.setTitle("确认", for: .normal)
        }
        button.sizeToFit()
        return UIBarButtonItem(customView: button)
    }
    
    ///EZSE: Pushes a view controller onto the receiver’s stack and updates the display.
    open func pushVC(_ vc: UIViewController) {
        navigationController?.pushViewController(vc, animated: true)
    }
    
    ///EZSE: Pops the top view controller from the navigation stack and updates the display.
    open func popVC() {
        _ = navigationController?.popViewController(animated: true)
    }
    
    /// EZSE: Hide or show navigation bar
    public var isNavBarHidden: Bool {
        get {
            return (navigationController?.isNavigationBarHidden)!
        }
        set {
            navigationController?.isNavigationBarHidden = newValue
        }
    }
    
    /// EZSE: Added extension for popToRootViewController
    open func popToRootVC() {
        _ = navigationController?.popToRootViewController(animated: true)
    }
    
    ///EZSE: Presents a view controller modally.
    open func presentVC(_ vc: UIViewController) {
        present(vc, animated: true, completion: nil)
    }
    
    /// 显示加载中
    open func startLoading() {
        let titleView = UIView(frame: CGRect(x: 0, y: 0, width: 100, height: 40))
        navigationItem.titleView = titleView
        let loadingLabel = UILabel()
        loadingLabel.text = "加载中..."
        loadingLabel.textColor = UIColor.white
        loadingLabel.textAlignment = .center
        loadingLabel.font = UIFont.boldSystemFont(ofSize: 16)
        titleView.addSubview(loadingLabel)
        loadingLabel.snp.makeConstraints({ (make) in
            make.center.equalTo(titleView.snp.center)
        })
        let loadingView = UIActivityIndicatorView(activityIndicatorStyle: .white)
        loadingView.startAnimating()
        titleView.addSubview(loadingView)
        loadingView.snp.makeConstraints({ (make) in
            make.centerX.equalTo(titleView.snp.centerX).offset(-50)
            make.centerY.equalTo(titleView.snp.centerY)
            make.size.equalTo(CGSize(width: 30, height: 30))
        })
    }
    
    // MARK: - 停止加载中
    open func stopLoading() {
        self.navigationItem.titleView = nil
        
    }
}







