//
//  UIView+Extension.swift
//  Tool_Swift
//
//  Created by 曹云霄 on 2017/2/17.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit


/// 对UIView的扩展
extension UIView {
    /// X值
    var X: CGFloat {
        return self.frame.origin.x
    }
    /// Y值
    var Y: CGFloat {
        return self.frame.origin.y
    }
    /// 宽度
    var width: CGFloat {
        return self.frame.size.width
    }
    ///高度
    var height: CGFloat {
        return self.frame.size.height
    }
    var size: CGSize {
        return self.frame.size
    }
    var point: CGPoint {
        return self.frame.origin
    }
    
    /// 添加圆角
    func addAngle(_ cornerRadius:CGFloat) {
        self.layer.masksToBounds = true
        self.layer.cornerRadius = cornerRadius
    }
    
    /// 添加边框
    func addBorder(_ border: CGFloat, _ color: UIColor) {
        self.layer.borderWidth = border
        self.layer.borderColor = color.cgColor
    }
    
    /// 添加阴影
    func addShadow(_ color: UIColor) {
        layer.shadowOpacity = Float(0.3)
        layer.shadowColor = color.cgColor
        layer.shadowOffset = CGSize(width: 0, height: 0)
        layer.shadowRadius = 5
    }
    
    /// 设置X
    func setx(x: CGFloat) {
        self.frame = CGRect(x: x, y: self.Y, width: self.width, height: self.height)
    }
    
    /// 设置Y
    func sety(y: CGFloat) {
        self.frame = CGRect(x: self.X, y: y, width: self.width, height: self.height)
    }
    
    /// 设置W
    func setw(w: CGFloat) {
        self.frame = CGRect(x: self.X, y: self.Y, width: w, height: self.height)
    }
    
    /// 设置H
    func seth(h: CGFloat) {
        self.frame = CGRect(x: self.X, y: self.Y, width: self.width, height: h)
    }
    
    /// 返回UIView名字
    class func name() ->String {
        return "\(self)"
    }
}


// MARK: - xib初始化
extension UIView {
    public class func instantiateFromNib() -> UIView {
        return Bundle.main.loadNibNamed(name(), owner: nil, options: nil)?.first as! UIView
    }
}


/// 扩展storyboard
@IBDesignable
class CustomView: UIView {
    //边框颜色
    @IBInspectable var borderColor: UIColor = UIColor() {
        didSet{
            layer.borderColor = borderColor.cgColor
        }
    }
    //边框距离
    @IBInspectable var borderWindth: CGFloat = 0.0 {
        didSet {
            layer.borderWidth = borderWindth
        }
    }
    //角度
    @IBInspectable var cornerRadius: CGFloat = 0.0 {
        didSet {
            layer.masksToBounds = true
            layer.cornerRadius = cornerRadius
        }
    }
    //阴影颜色
    @IBInspectable var shadowOpacity: CGFloat = 0.0 {
        didSet {
            layer.shadowOpacity = Float(shadowOpacity)
            layer.shadowColor = UIColor.black.cgColor
            layer.shadowOffset = CGSize(width: 0, height: 0)
        }
    }
    //阴影大小
    @IBInspectable var shadowRadius: CGFloat = 0.0 {
        didSet {
            layer.shadowRadius = shadowRadius
        }
    }
}

/// 扩展storyboard
@IBDesignable
class CustomButton: UIButton {
    //边框颜色
    @IBInspectable var borderColor: UIColor = UIColor() {
        didSet{
            layer.borderColor = borderColor.cgColor
        }
    }
    //边框距离
    @IBInspectable var borderWindth: CGFloat = 0.0 {
        didSet {
            layer.borderWidth = borderWindth
        }
    }
    //角度
    @IBInspectable var cornerRadius: CGFloat = 0.0 {
        didSet {
            layer.masksToBounds = true
            layer.cornerRadius = cornerRadius
        }
    }
    //阴影颜色
    @IBInspectable var shadowOpacity: CGFloat = 0.0 {
        didSet {
            layer.shadowOpacity = Float(shadowOpacity)
            layer.shadowColor = UIColor.black.cgColor
            layer.shadowOffset = CGSize.init(width: 0, height: 0)
        }
    }
    //阴影大小
    @IBInspectable var shadowRadius: CGFloat = 0.0 {
        didSet {
            layer.shadowRadius = shadowRadius
        }
    }
    
    
    override var isHighlighted: Bool {
        set{
            
        }
        get {
            return false
        }
    }
    
    
}

/// 扩展storyboard
@IBDesignable
class CustomImageView: UIImageView {
    
    
    //边框颜色
    @IBInspectable var borderColor: UIColor = UIColor() {
        didSet{
            layer.borderColor = borderColor.cgColor
        }
    }
    //边框距离
    @IBInspectable var borderWindth: CGFloat = 0.0 {
        didSet {
            layer.borderWidth = borderWindth
        }
    }
    //角度
    @IBInspectable var cornerRadius: CGFloat = 0.0 {
        didSet {
            layer.masksToBounds = true
            layer.cornerRadius = cornerRadius
        }
    }
    //阴影颜色
    @IBInspectable var shadowOpacity: CGFloat = 0.0 {
        didSet {
            layer.shadowOpacity = Float(shadowOpacity)
            layer.shadowColor = UIColor.black.cgColor
            layer.shadowOffset = CGSize.init(width: 0, height: 0)
        }
    }
    //阴影大小
    @IBInspectable var shadowRadius: CGFloat = 0.0 {
        didSet {
            layer.shadowRadius = shadowRadius
        }
    }
}


/// 扩展storyboard
@IBDesignable
class CustomTextView: UITextView {
    //边框颜色
    @IBInspectable var borderColor: UIColor = UIColor() {
        didSet{
            layer.borderColor = borderColor.cgColor
        }
    }
    //边框距离
    @IBInspectable var borderWindth: CGFloat = 0.0 {
        didSet {
            layer.borderWidth = borderWindth
        }
    }
    //角度
    @IBInspectable var cornerRadius: CGFloat = 0.0 {
        didSet {
            layer.masksToBounds = true
            layer.cornerRadius = cornerRadius
        }
    }
    //阴影颜色
    @IBInspectable var shadowOpacity: CGFloat = 0.0 {
        didSet {
            layer.shadowOpacity = Float(shadowOpacity)
            layer.shadowColor = UIColor.black.cgColor
            layer.shadowOffset = CGSize.init(width: 0, height: 0)
        }
    }
    //阴影大小
    @IBInspectable var shadowRadius: CGFloat = 0.0 {
        didSet {
            layer.shadowRadius = shadowRadius
        }
    }
}

class CustomLabel: UILabel {
    
    //添加下划线
    func addUnderline(_ text: String,color: UIColor) {
        let string = NSMutableAttributedString(string: text)
        let range1 = NSRange(location: 0, length: string.length)
        let number = NSNumber(value:NSUnderlineStyle.styleSingle.rawValue)//此处需要转换为NSNumber 不然不对,rawValue转换为integer
        string.addAttribute(NSAttributedStringKey.underlineStyle, value: number, range: range1)
        string.addAttribute(NSAttributedStringKey.foregroundColor, value: color, range: range1)
        self.attributedText = string
    }
}

















