//
//  String+Extension.swift
//  CStoreEdu-iOS
//
//  Created by 曹云霄 on 2017/3/21.
//  Copyright © 2017年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

extension String {
    
    // 计算字符串的宽度，高度
    public func calculateStringSize(_ size: CGSize,font: UIFont) ->CGSize {
        let attributes = [NSAttributedStringKey.font:font]
        let option = NSStringDrawingOptions.usesLineFragmentOrigin
        let rect:CGRect = self.boundingRect(with:CGSize(width: kWidth, height: kHeight) , options: option, attributes: attributes, context: nil)
        return rect.size
    }
    
    // 去掉字符串前后空格
    public func formatString() -> String {
        let set = NSCharacterSet.whitespacesAndNewlines
        return self.trimmingCharacters(in: set)
    }
}


extension String {
    
    //将原始的url编码为合法的url
    func urlEncoded() -> String {
        let encodeUrlString = self.addingPercentEncoding(withAllowedCharacters:
            .urlQueryAllowed)
        return encodeUrlString ?? ""
    }
    
    //将编码后的url转换回原始的url
    func urlDecoded() -> String {
        return self.removingPercentEncoding ?? ""
    }
}
