//
//  Public.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/11/29.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation
import UIKit
import RxSwift

// MARK: - 常用颜色
public var kNavColor: UIColor = UIColor.RGB(44, g: 48, b: 52)
public let kMainColor: UIColor = UIColor.RGB(67, g: 132, b: 196)
public let kBlueColor: UIColor = UIColor.RGB(77, g: 131, b: 242)
public let kGaryColor: UIColor = UIColor.RGB(240, g: 240, b: 240)
public let kLightGaryColor: UIColor = UIColor.RGB(170, g: 170, b: 170)
public let kYellowColor: UIColor = UIColor.RGB(253, g: 156, b: 79)
public let kBlackColor: UIColor = UIColor.black

// MARK: - 全局常用属性
public let kNavHeight: CGFloat = 64
public let kCellHeight: CGFloat = 44
public let kTabBarHeight: CGFloat = 49
public let kROWS: Int = 15
public let kONE: Int = 1
public let kZERO: Int = 0
public let kPageSize: Int = 15
public let kSectionZero: CGFloat = 0.01
public let kSectionTen: CGFloat = 10
public let kEmptyHeight: CGFloat = 108
public let kAnimationTime: TimeInterval = 0.3
public let kWidth: CGFloat = UIScreen.main.bounds.size.width
public let kHeight: CGFloat = UIScreen.main.bounds.size.height
public let kWindow: UIWindow = ((UIApplication.shared.delegate?.window)!)!

/// 用户信息
public func kUser() -> UserModel {
    return AppManager.shareInstance.userModel!
}

/// 工单状态回调
public typealias BillStateBlock = (String) ->Void
/// 悬浮框透明度回调
public typealias SuspendViewAlphaBlock = (CGFloat) ->Void
/// 悬浮框状态回调
public typealias SuspendViewStateBlock = (BillDetailExecute,IndexPath,String) ->Void
/// 图片加载占位图
public let loadingImage: UIImage = UIImage(named: "loading")!
/// 添加图片
public let add_Photo: String = "add_photo"
/// 子订单完成界面，维修前、维修后
public let after: String = "after"
public let befor: String = "befor"
public let sure: String = "确认"
public let cancel: String = "取消"
public let hint: String = "提示"




